/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class EipConnectionRequest
extends EipPacket
implements Message {
    public static final Integer PROTOCOLVERSION = 1;
    public static final Integer FLAGS = 0;

    @Override
    public Integer getCommand() {
        return 101;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Integer getPacketLength() {
        return 0;
    }

    public EipConnectionRequest(long sessionHandle, long status, byte[] senderContext, long options) {
        super(sessionHandle, status, senderContext, options);
    }

    public int getProtocolVersion() {
        return PROTOCOLVERSION;
    }

    public int getFlags() {
        return FLAGS;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EipConnectionRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("protocolVersion", PROTOCOLVERSION, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("flags", FLAGS, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("EipConnectionRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EipConnectionRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static EipPacket.EipPacketBuilder staticParseEipPacketBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("EipConnectionRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int protocolVersion = FieldReaderFactory.readConstField("protocolVersion", DataReaderFactory.readUnsignedInt(readBuffer, 16), PROTOCOLVERSION, new WithReaderArgs[0]);
        int flags = FieldReaderFactory.readConstField("flags", DataReaderFactory.readUnsignedInt(readBuffer, 16), FLAGS, new WithReaderArgs[0]);
        readBuffer.closeContext("EipConnectionRequest", new WithReaderArgs[0]);
        return new EipConnectionRequestBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipConnectionRequest)) {
            return false;
        }
        EipConnectionRequest that = (EipConnectionRequest)o;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EipConnectionRequestBuilderImpl
    implements EipPacket.EipPacketBuilder {
        @Override
        public EipConnectionRequest build(long sessionHandle, long status, byte[] senderContext, long options) {
            EipConnectionRequest eipConnectionRequest = new EipConnectionRequest(sessionHandle, status, senderContext, options);
            return eipConnectionRequest;
        }
    }
}

