/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipRRData;
import org.apache.plc4x.java.eip.readwrite.EipConnectionRequest;
import org.apache.plc4x.java.eip.readwrite.EipConnectionResponse;
import org.apache.plc4x.java.eip.readwrite.EipDisconnectRequest;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityRequest;
import org.apache.plc4x.java.eip.readwrite.EipListIdentityResponse;
import org.apache.plc4x.java.eip.readwrite.ListServicesRequest;
import org.apache.plc4x.java.eip.readwrite.ListServicesResponse;
import org.apache.plc4x.java.eip.readwrite.NullCommandRequest;
import org.apache.plc4x.java.eip.readwrite.NullCommandResponse;
import org.apache.plc4x.java.eip.readwrite.NullEipConnectionResponse;
import org.apache.plc4x.java.eip.readwrite.NullListServicesResponse;
import org.apache.plc4x.java.eip.readwrite.SendUnitData;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class EipPacket
implements Message {
    protected final long sessionHandle;
    protected final long status;
    protected final byte[] senderContext;
    protected final long options;

    public abstract Integer getCommand();

    public abstract Integer getPacketLength();

    public abstract Boolean getResponse();

    public EipPacket(long sessionHandle, long status, byte[] senderContext, long options) {
        this.sessionHandle = sessionHandle;
        this.status = status;
        this.senderContext = senderContext;
        this.options = options;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public long getStatus() {
        return this.status;
    }

    public byte[] getSenderContext() {
        return this.senderContext;
    }

    public long getOptions() {
        return this.options;
    }

    protected abstract void serializeEipPacketChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EipPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("command", this.getCommand(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int packetLength = this.getLengthInBytes() - 24;
        FieldWriterFactory.writeImplicitField("packetLength", packetLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sessionHandle", this.sessionHandle, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("status", this.status, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("senderContext", this.senderContext, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("options", this.options, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        this.serializeEipPacketChild(writeBuffer);
        writeBuffer.popContext("EipPacket", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        EipPacket _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.senderContext != null) {
            lengthInBits += 8 * this.senderContext.length;
        }
        return lengthInBits += 32;
    }

    public static EipPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return EipPacket.staticParse(readBuffer, response);
    }

    public static EipPacket staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("EipPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int command = FieldReaderFactory.readDiscriminatorField("command", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int packetLength = FieldReaderFactory.readImplicitField("packetLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        long sessionHandle = FieldReaderFactory.readSimpleField("sessionHandle", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long status = FieldReaderFactory.readSimpleField("status", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        byte[] senderContext = readBuffer.readByteArray("senderContext", Math.toIntExact(8L), new WithReaderArgs[0]);
        long options = FieldReaderFactory.readSimpleField("options", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        EipPacketBuilder builder = null;
        if (EvaluationHelper.equals(command, 1) && EvaluationHelper.equals(response, false)) {
            builder = NullCommandRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 1) && EvaluationHelper.equals(response, true)) {
            builder = NullCommandResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 4) && EvaluationHelper.equals(response, false)) {
            builder = ListServicesRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 4) && EvaluationHelper.equals(response, true) && EvaluationHelper.equals(packetLength, 0)) {
            builder = NullListServicesResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 4) && EvaluationHelper.equals(response, true)) {
            builder = ListServicesResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 99) && EvaluationHelper.equals(response, false)) {
            builder = EipListIdentityRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 99) && EvaluationHelper.equals(response, true)) {
            builder = EipListIdentityResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 101) && EvaluationHelper.equals(response, false)) {
            builder = EipConnectionRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 101) && EvaluationHelper.equals(response, true) && EvaluationHelper.equals(packetLength, 0)) {
            builder = NullEipConnectionResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 101) && EvaluationHelper.equals(response, true)) {
            builder = EipConnectionResponse.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 102)) {
            builder = EipDisconnectRequest.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 111)) {
            builder = CipRRData.staticParseEipPacketBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(command, 112)) {
            builder = SendUnitData.staticParseEipPacketBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [command=" + command + " " + "response=" + response + " " + "packetLength=" + packetLength + "]");
        }
        readBuffer.closeContext("EipPacket", new WithReaderArgs[0]);
        EipPacket _eipPacket = builder.build(sessionHandle, status, senderContext, options);
        return _eipPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipPacket)) {
            return false;
        }
        EipPacket that = (EipPacket)o;
        return this.getSessionHandle() == that.getSessionHandle() && this.getStatus() == that.getStatus() && this.getSenderContext() == that.getSenderContext() && this.getOptions() == that.getOptions();
    }

    public int hashCode() {
        return Objects.hash(this.getSessionHandle(), this.getStatus(), this.getSenderContext(), this.getOptions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface EipPacketBuilder {
        public EipPacket build(long var1, long var3, byte[] var5, long var6);
    }
}

