/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class NetworkConnectionParameters
implements Message {
    protected final int connectionSize;
    protected final boolean owner;
    protected final byte connectionType;
    protected final byte priority;
    protected final boolean connectionSizeType;

    public NetworkConnectionParameters(int connectionSize, boolean owner, byte connectionType, byte priority, boolean connectionSizeType) {
        this.connectionSize = connectionSize;
        this.owner = owner;
        this.connectionType = connectionType;
        this.priority = priority;
        this.connectionSizeType = connectionSizeType;
    }

    public int getConnectionSize() {
        return this.connectionSize;
    }

    public boolean getOwner() {
        return this.owner;
    }

    public byte getConnectionType() {
        return this.connectionType;
    }

    public byte getPriority() {
        return this.priority;
    }

    public boolean getConnectionSizeType() {
        return this.connectionSizeType;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NetworkConnectionParameters", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("connectionSize", this.connectionSize, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("owner", this.owner, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("connectionType", this.connectionType, DataWriterFactory.writeUnsignedByte(writeBuffer, 2), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", false, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("priority", this.priority, DataWriterFactory.writeUnsignedByte(writeBuffer, 2), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("connectionSizeType", this.connectionSizeType, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", false, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("NetworkConnectionParameters", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        NetworkConnectionParameters _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        ++lengthInBits;
        lengthInBits += 2;
        ++lengthInBits;
        lengthInBits += 2;
        ++lengthInBits;
        return ++lengthInBits;
    }

    public static NetworkConnectionParameters staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return NetworkConnectionParameters.staticParse(readBuffer);
    }

    public static NetworkConnectionParameters staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("NetworkConnectionParameters", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int connectionSize = FieldReaderFactory.readSimpleField("connectionSize", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
        boolean owner = FieldReaderFactory.readSimpleField("owner", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte connectionType = FieldReaderFactory.readSimpleField("connectionType", DataReaderFactory.readUnsignedByte(readBuffer, 2), new WithReaderArgs[0]);
        Boolean reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readBoolean(readBuffer), false, new WithReaderArgs[0]);
        byte priority = FieldReaderFactory.readSimpleField("priority", DataReaderFactory.readUnsignedByte(readBuffer, 2), new WithReaderArgs[0]);
        boolean connectionSizeType = FieldReaderFactory.readSimpleField("connectionSizeType", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        Boolean reservedField2 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readBoolean(readBuffer), false, new WithReaderArgs[0]);
        readBuffer.closeContext("NetworkConnectionParameters", new WithReaderArgs[0]);
        NetworkConnectionParameters _networkConnectionParameters = new NetworkConnectionParameters(connectionSize, owner, connectionType, priority, connectionSizeType);
        return _networkConnectionParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkConnectionParameters)) {
            return false;
        }
        NetworkConnectionParameters that = (NetworkConnectionParameters)o;
        return this.getConnectionSize() == that.getConnectionSize() && this.getOwner() == that.getOwner() && this.getConnectionType() == that.getConnectionType() && this.getPriority() == that.getPriority() && this.getConnectionSizeType() == that.getConnectionSizeType();
    }

    public int hashCode() {
        return Objects.hash(this.getConnectionSize(), this.getOwner(), this.getConnectionType(), this.getPriority(), this.getConnectionSizeType());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

