/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.PortSegmentType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class PortSegmentExtended
extends PortSegmentType
implements Message {
    protected final byte port;
    protected final short linkAddressSize;
    protected final String address;

    @Override
    public Boolean getExtendedLinkAddress() {
        return true;
    }

    public PortSegmentExtended(byte port, short linkAddressSize, String address) {
        this.port = port;
        this.linkAddressSize = linkAddressSize;
        this.address = address;
    }

    public byte getPort() {
        return this.port;
    }

    public short getLinkAddressSize() {
        return this.linkAddressSize;
    }

    public String getAddress() {
        return this.address;
    }

    public short getPaddingByte() {
        return (short)(this.getLinkAddressSize() % 2);
    }

    @Override
    protected void serializePortSegmentTypeChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PortSegmentExtended", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("port", this.port, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("linkAddressSize", this.linkAddressSize, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        short paddingByte = this.getPaddingByte();
        writeBuffer.writeVirtual("paddingByte", paddingByte, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("address", this.address, DataWriterFactory.writeString(writeBuffer, this.linkAddressSize * 8 + paddingByte * 8), new WithWriterArgs[0]);
        writeBuffer.popContext("PortSegmentExtended", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        PortSegmentExtended _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        lengthInBits += 8;
        return lengthInBits += this.getLinkAddressSize() * 8 + this.getPaddingByte() * 8;
    }

    public static PortSegmentType.PortSegmentTypeBuilder staticParsePortSegmentTypeBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("PortSegmentExtended", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte port = FieldReaderFactory.readSimpleField("port", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        short linkAddressSize = FieldReaderFactory.readSimpleField("linkAddressSize", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        short paddingByte = FieldReaderFactory.readVirtualField("paddingByte", Short.TYPE, linkAddressSize % 2, new WithReaderArgs[0]);
        String address = FieldReaderFactory.readSimpleField("address", DataReaderFactory.readString(readBuffer, linkAddressSize * 8 + paddingByte * 8), new WithReaderArgs[0]);
        readBuffer.closeContext("PortSegmentExtended", new WithReaderArgs[0]);
        return new PortSegmentExtendedBuilderImpl(port, linkAddressSize, address);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortSegmentExtended)) {
            return false;
        }
        PortSegmentExtended that = (PortSegmentExtended)o;
        return this.getPort() == that.getPort() && this.getLinkAddressSize() == that.getLinkAddressSize() && this.getAddress() == that.getAddress() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPort(), this.getLinkAddressSize(), this.getAddress());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PortSegmentExtendedBuilderImpl
    implements PortSegmentType.PortSegmentTypeBuilder {
        private final byte port;
        private final short linkAddressSize;
        private final String address;

        public PortSegmentExtendedBuilderImpl(byte port, short linkAddressSize, String address) {
            this.port = port;
            this.linkAddressSize = linkAddressSize;
            this.address = address;
        }

        @Override
        public PortSegmentExtended build() {
            PortSegmentExtended portSegmentExtended = new PortSegmentExtended(this.port, this.linkAddressSize, this.address);
            return portSegmentExtended;
        }
    }
}

