/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.eip.readwrite.TypeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SendUnitData
extends EipPacket
implements Message {
    public static final Long INTERFACEHANDLE = 0L;
    protected final int timeout;
    protected final List<TypeId> typeIds;

    @Override
    public Integer getCommand() {
        return 112;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Integer getPacketLength() {
        return 0;
    }

    public SendUnitData(long sessionHandle, long status, byte[] senderContext, long options, int timeout, List<TypeId> typeIds) {
        super(sessionHandle, status, senderContext, options);
        this.timeout = timeout;
        this.typeIds = typeIds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<TypeId> getTypeIds() {
        return this.typeIds;
    }

    public long getInterfaceHandle() {
        return INTERFACEHANDLE;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SendUnitData", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("interfaceHandle", INTERFACEHANDLE, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timeout", this.timeout, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int typeIdCount = StaticHelper.COUNT(this.getTypeIds());
        FieldWriterFactory.writeImplicitField("typeIdCount", typeIdCount, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("typeIds", this.typeIds, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("SendUnitData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SendUnitData _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.typeIds != null) {
            int i = 0;
            for (TypeId element : this.typeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.typeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static EipPacket.EipPacketBuilder staticParseEipPacketBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("SendUnitData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long interfaceHandle = FieldReaderFactory.readConstField("interfaceHandle", DataReaderFactory.readUnsignedLong(readBuffer, 32), INTERFACEHANDLE, new WithReaderArgs[0]);
        int timeout = FieldReaderFactory.readSimpleField("timeout", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int typeIdCount = FieldReaderFactory.readImplicitField("typeIdCount", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        List<TypeId> typeIds = FieldReaderFactory.readCountArrayField("typeIds", new DataReaderComplexDefault<TypeId>(() -> TypeId.staticParse(readBuffer), readBuffer), typeIdCount, new WithReaderArgs[0]);
        readBuffer.closeContext("SendUnitData", new WithReaderArgs[0]);
        return new SendUnitDataBuilderImpl(timeout, typeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SendUnitData)) {
            return false;
        }
        SendUnitData that = (SendUnitData)o;
        return this.getTimeout() == that.getTimeout() && this.getTypeIds() == that.getTypeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTimeout(), this.getTypeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SendUnitDataBuilderImpl
    implements EipPacket.EipPacketBuilder {
        private final int timeout;
        private final List<TypeId> typeIds;

        public SendUnitDataBuilderImpl(int timeout, List<TypeId> typeIds) {
            this.timeout = timeout;
            this.typeIds = typeIds;
        }

        @Override
        public SendUnitData build(long sessionHandle, long status, byte[] senderContext, long options) {
            SendUnitData sendUnitData = new SendUnitData(sessionHandle, status, senderContext, options, this.timeout, this.typeIds);
            return sendUnitData;
        }
    }
}

