/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.context;

import java.io.File;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpConfiguration;
import org.apache.plc4x.java.knxnetip.ets.EtsParser;
import org.apache.plc4x.java.knxnetip.ets.model.EtsModel;
import org.apache.plc4x.java.knxnetip.readwrite.IPAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxAddress;
import org.apache.plc4x.java.knxnetip.readwrite.KnxLayer;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;

public class KnxNetIpDriverContext
implements DriverContext,
HasConfiguration<KnxNetIpConfiguration> {
    private boolean passiveMode = false;
    private KnxAddress gatewayAddress;
    private String gatewayName;
    private IPAddress localIPAddress;
    private int localPort;
    private short communicationChannelId;
    private KnxAddress clientKnxAddress;
    private byte groupAddressType;
    private KnxLayer tunnelConnectionType;
    private EtsModel etsModel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setConfiguration(KnxNetIpConfiguration configuration) {
        if (configuration.knxprojFilePath != null) {
            File knxprojFile = new File(configuration.knxprojFilePath);
            if (!knxprojFile.exists() || !knxprojFile.isFile()) throw new PlcRuntimeException(String.format("File specified with 'knxproj-file-path' does not exist or is not a file: '%s'", configuration.knxprojFilePath));
            EtsParser parser = new EtsParser();
            this.etsModel = parser.parse(knxprojFile, configuration.knxprojPassword);
            this.groupAddressType = this.etsModel.getGroupAddressType();
        } else {
            this.groupAddressType = (byte)configuration.groupAddressNumLevels;
        }
        this.tunnelConnectionType = KnxLayer.valueOf("TUNNEL_" + configuration.getConnectionType());
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public KnxAddress getGatewayAddress() {
        return this.gatewayAddress;
    }

    public void setGatewayAddress(KnxAddress gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public IPAddress getLocalIPAddress() {
        return this.localIPAddress;
    }

    public void setLocalIPAddress(IPAddress localIPAddress) {
        this.localIPAddress = localIPAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public short getCommunicationChannelId() {
        return this.communicationChannelId;
    }

    public void setCommunicationChannelId(short communicationChannelId) {
        this.communicationChannelId = communicationChannelId;
    }

    public KnxAddress getClientKnxAddress() {
        return this.clientKnxAddress;
    }

    public void setClientKnxAddress(KnxAddress clientKnxAddress) {
        this.clientKnxAddress = clientKnxAddress;
    }

    public byte getGroupAddressType() {
        return this.groupAddressType;
    }

    public KnxLayer getTunnelConnectionType() {
        return this.tunnelConnectionType;
    }

    public EtsModel getEtsModel() {
        return this.etsModel;
    }
}

