/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.ets.model;

import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.knxnetip.ets.model.GroupAddress;

public class EtsModel {
    private final byte groupAddressType;
    private final Map<String, GroupAddress> groupAddresses;
    private final Map<String, String> topologyNames;

    public EtsModel(byte groupAddressType, Map<String, GroupAddress> groupAddresses, Map<String, String> topologyNames) {
        this.groupAddressType = groupAddressType;
        this.groupAddresses = groupAddresses;
        this.topologyNames = topologyNames;
    }

    public byte getGroupAddressType() {
        return this.groupAddressType;
    }

    public static String parseGroupAddress(byte groupAddressType, byte[] addressBytes) {
        int addressInt = addressBytes[0] << 8 | addressBytes[1] & 0xFF;
        return EtsModel.parseGroupAddress(groupAddressType, addressInt);
    }

    public static String parseGroupAddress(byte groupAddressType, int addressInt) {
        switch (groupAddressType) {
            case 1: {
                return Integer.toString(addressInt);
            }
            case 2: {
                int mainGroup = (addressInt & 0xF800) >> 11;
                int subGroup = addressInt & 0x7FF;
                return String.valueOf(mainGroup) + "/" + subGroup;
            }
            case 3: {
                int mainGroup = (addressInt & 0xF800) >> 11;
                int middleGroup = (addressInt & 0x700) >> 8;
                int subGroup = addressInt & 0xFF;
                return String.valueOf(mainGroup) + "/" + middleGroup + "/" + subGroup;
            }
        }
        return null;
    }

    public String parseGroupAddress(byte[] addressBytes) {
        int addressInt = addressBytes[0] << 8 | addressBytes[1] & 0xFF;
        return EtsModel.parseGroupAddress(this.getGroupAddressType(), addressInt);
    }

    public String parseGroupAddress(int addressInt) {
        return EtsModel.parseGroupAddress(this.getGroupAddressType(), addressInt);
    }

    public Map<String, GroupAddress> getGroupAddresses() {
        return this.groupAddresses;
    }

    public String getTopologyName(String addressPart) {
        return this.topologyNames.get(addressPart);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EtsModel)) {
            return false;
        }
        EtsModel etsModel = (EtsModel)o;
        return new EqualsBuilder().append(this.getGroupAddressType(), etsModel.getGroupAddressType()).append(this.getGroupAddresses(), etsModel.getGroupAddresses()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getGroupAddressType()).append(this.getGroupAddresses()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("groupAddressNumLevels", this.groupAddressType).append("groupAddresses", this.groupAddresses).toString();
    }
}

