/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.knxnetip.readwrite.ApduControlContainer;
import org.apache.plc4x.java.knxnetip.readwrite.ApduDataContainer;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class Apdu
implements Message {
    protected final boolean numbered;
    protected final byte counter;

    public abstract Byte getControl();

    public Apdu(boolean numbered, byte counter) {
        this.numbered = numbered;
        this.counter = counter;
    }

    public boolean getNumbered() {
        return this.numbered;
    }

    public byte getCounter() {
        return this.counter;
    }

    protected abstract void serializeApduChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Apdu", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("control", this.getControl(), DataWriterFactory.writeUnsignedByte(writeBuffer, 1), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("numbered", this.numbered, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("counter", this.counter, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        this.serializeApduChild(writeBuffer);
        writeBuffer.popContext("Apdu", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        Apdu _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        ++lengthInBits;
        return lengthInBits += 4;
    }

    public static Apdu staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Short dataLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            dataLength = (Short)args[0];
        } else if (args[0] instanceof String) {
            dataLength = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        return Apdu.staticParse(readBuffer, dataLength);
    }

    public static Apdu staticParse(ReadBuffer readBuffer, Short dataLength) throws ParseException {
        readBuffer.pullContext("Apdu", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte control = FieldReaderFactory.readDiscriminatorField("control", DataReaderFactory.readUnsignedByte(readBuffer, 1), new WithReaderArgs[0]);
        boolean numbered = FieldReaderFactory.readSimpleField("numbered", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte counter = FieldReaderFactory.readSimpleField("counter", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        ApduBuilder builder = null;
        if (EvaluationHelper.equals(control, (byte)1)) {
            builder = ApduControlContainer.staticParseApduBuilder(readBuffer, dataLength);
        } else if (EvaluationHelper.equals(control, (byte)0)) {
            builder = ApduDataContainer.staticParseApduBuilder(readBuffer, dataLength);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [control=" + control + "]");
        }
        readBuffer.closeContext("Apdu", new WithReaderArgs[0]);
        Apdu _apdu = builder.build(numbered, counter);
        return _apdu;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Apdu)) {
            return false;
        }
        Apdu that = (Apdu)o;
        return this.getNumbered() == that.getNumbered() && this.getCounter() == that.getCounter();
    }

    public int hashCode() {
        return Objects.hash(this.getNumbered(), this.getCounter());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface ApduBuilder {
        public Apdu build(boolean var1, byte var2);
    }
}

