/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ChannelInformation
implements Message {
    protected final byte numChannels;
    protected final short channelCode;

    public ChannelInformation(byte numChannels, short channelCode) {
        this.numChannels = numChannels;
        this.channelCode = channelCode;
    }

    public byte getNumChannels() {
        return this.numChannels;
    }

    public short getChannelCode() {
        return this.channelCode;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ChannelInformation", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("numChannels", this.numChannels, DataWriterFactory.writeUnsignedByte(writeBuffer, 3), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("channelCode", this.channelCode, DataWriterFactory.writeUnsignedShort(writeBuffer, 13), new WithWriterArgs[0]);
        writeBuffer.popContext("ChannelInformation", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        ChannelInformation _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 3;
        return lengthInBits += 13;
    }

    public static ChannelInformation staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ChannelInformation.staticParse(readBuffer);
    }

    public static ChannelInformation staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ChannelInformation", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte numChannels = FieldReaderFactory.readSimpleField("numChannels", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
        short channelCode = FieldReaderFactory.readSimpleField("channelCode", DataReaderFactory.readUnsignedShort(readBuffer, 13), new WithReaderArgs[0]);
        readBuffer.closeContext("ChannelInformation", new WithReaderArgs[0]);
        ChannelInformation _channelInformation = new ChannelInformation(numChannels, channelCode);
        return _channelInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelInformation)) {
            return false;
        }
        ChannelInformation that = (ChannelInformation)o;
        return this.getNumChannels() == that.getNumChannels() && this.getChannelCode() == that.getChannelCode();
    }

    public int hashCode() {
        return Objects.hash(this.getNumChannels(), this.getChannelCode());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

