/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress2Level;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress3Level;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddressFreeLevel;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class KnxGroupAddress
implements Message {
    public abstract Byte getNumLevels();

    protected abstract void serializeKnxGroupAddressChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("KnxGroupAddress", new WithWriterArgs[0]);
        this.serializeKnxGroupAddressChild(writeBuffer);
        writeBuffer.popContext("KnxGroupAddress", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        KnxGroupAddress _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static KnxGroupAddress staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Byte numLevels;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Byte) {
            numLevels = (Byte)args[0];
        } else if (args[0] instanceof String) {
            numLevels = Byte.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Byte or a string which is parseable but was " + args[0].getClass().getName());
        }
        return KnxGroupAddress.staticParse(readBuffer, numLevels);
    }

    public static KnxGroupAddress staticParse(ReadBuffer readBuffer, Byte numLevels) throws ParseException {
        readBuffer.pullContext("KnxGroupAddress", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        KnxGroupAddressBuilder builder = null;
        if (EvaluationHelper.equals(numLevels, (byte)1)) {
            builder = KnxGroupAddressFreeLevel.staticParseKnxGroupAddressBuilder(readBuffer, numLevels);
        } else if (EvaluationHelper.equals(numLevels, (byte)2)) {
            builder = KnxGroupAddress2Level.staticParseKnxGroupAddressBuilder(readBuffer, numLevels);
        } else if (EvaluationHelper.equals(numLevels, (byte)3)) {
            builder = KnxGroupAddress3Level.staticParseKnxGroupAddressBuilder(readBuffer, numLevels);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [numLevels=" + numLevels + "]");
        }
        readBuffer.closeContext("KnxGroupAddress", new WithReaderArgs[0]);
        KnxGroupAddress _knxGroupAddress = builder.build();
        return _knxGroupAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnxGroupAddress)) {
            return false;
        }
        KnxGroupAddress that = (KnxGroupAddress)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface KnxGroupAddressBuilder {
        public KnxGroupAddress build();
    }
}

