/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.KnxGroupAddress;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class KnxGroupAddress2Level
extends KnxGroupAddress
implements Message {
    protected final byte mainGroup;
    protected final short subGroup;

    @Override
    public Byte getNumLevels() {
        return (byte)2;
    }

    public KnxGroupAddress2Level(byte mainGroup, short subGroup) {
        this.mainGroup = mainGroup;
        this.subGroup = subGroup;
    }

    public byte getMainGroup() {
        return this.mainGroup;
    }

    public short getSubGroup() {
        return this.subGroup;
    }

    @Override
    protected void serializeKnxGroupAddressChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("KnxGroupAddress2Level", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("mainGroup", this.mainGroup, DataWriterFactory.writeUnsignedByte(writeBuffer, 5), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("subGroup", this.subGroup, DataWriterFactory.writeUnsignedShort(writeBuffer, 11), new WithWriterArgs[0]);
        writeBuffer.popContext("KnxGroupAddress2Level", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        KnxGroupAddress2Level _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 5;
        return lengthInBits += 11;
    }

    public static KnxGroupAddress.KnxGroupAddressBuilder staticParseKnxGroupAddressBuilder(ReadBuffer readBuffer, Byte numLevels) throws ParseException {
        readBuffer.pullContext("KnxGroupAddress2Level", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte mainGroup = FieldReaderFactory.readSimpleField("mainGroup", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
        short subGroup = FieldReaderFactory.readSimpleField("subGroup", DataReaderFactory.readUnsignedShort(readBuffer, 11), new WithReaderArgs[0]);
        readBuffer.closeContext("KnxGroupAddress2Level", new WithReaderArgs[0]);
        return new KnxGroupAddress2LevelBuilderImpl(mainGroup, subGroup);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnxGroupAddress2Level)) {
            return false;
        }
        KnxGroupAddress2Level that = (KnxGroupAddress2Level)o;
        return this.getMainGroup() == that.getMainGroup() && this.getSubGroup() == that.getSubGroup() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMainGroup(), this.getSubGroup());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class KnxGroupAddress2LevelBuilderImpl
    implements KnxGroupAddress.KnxGroupAddressBuilder {
        private final byte mainGroup;
        private final short subGroup;

        public KnxGroupAddress2LevelBuilderImpl(byte mainGroup, short subGroup) {
            this.mainGroup = mainGroup;
            this.subGroup = subGroup;
        }

        @Override
        public KnxGroupAddress2Level build() {
            KnxGroupAddress2Level knxGroupAddress2Level = new KnxGroupAddress2Level(this.mainGroup, this.subGroup);
            return knxGroupAddress2Level;
        }
    }
}

