/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.Apdu;
import org.apache.plc4x.java.knxnetip.readwrite.CEMIPriority;
import org.apache.plc4x.java.knxnetip.readwrite.KnxAddress;
import org.apache.plc4x.java.knxnetip.readwrite.LDataFrame;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class LDataExtended
extends LDataFrame
implements Message {
    protected final boolean groupAddress;
    protected final byte hopCount;
    protected final byte extendedFrameFormat;
    protected final KnxAddress sourceAddress;
    protected final byte[] destinationAddress;
    protected final Apdu apdu;

    @Override
    public Boolean getNotAckFrame() {
        return true;
    }

    @Override
    public Boolean getPolling() {
        return false;
    }

    public LDataExtended(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag, boolean groupAddress, byte hopCount, byte extendedFrameFormat, KnxAddress sourceAddress, byte[] destinationAddress, Apdu apdu) {
        super(frameType, notRepeated, priority, acknowledgeRequested, errorFlag);
        this.groupAddress = groupAddress;
        this.hopCount = hopCount;
        this.extendedFrameFormat = extendedFrameFormat;
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.apdu = apdu;
    }

    public boolean getGroupAddress() {
        return this.groupAddress;
    }

    public byte getHopCount() {
        return this.hopCount;
    }

    public byte getExtendedFrameFormat() {
        return this.extendedFrameFormat;
    }

    public KnxAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public byte[] getDestinationAddress() {
        return this.destinationAddress;
    }

    public Apdu getApdu() {
        return this.apdu;
    }

    @Override
    protected void serializeLDataFrameChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("LDataExtended", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("groupAddress", this.groupAddress, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("hopCount", this.hopCount, DataWriterFactory.writeUnsignedByte(writeBuffer, 3), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("extendedFrameFormat", this.extendedFrameFormat, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sourceAddress", this.sourceAddress, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("destinationAddress", this.destinationAddress, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        short dataLength = (short)(this.getApdu().getLengthInBytes() - 1);
        FieldWriterFactory.writeImplicitField("dataLength", dataLength, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("apdu", this.apdu, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("LDataExtended", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        LDataExtended _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        lengthInBits += 3;
        lengthInBits += 4;
        lengthInBits += this.sourceAddress.getLengthInBits();
        if (this.destinationAddress != null) {
            lengthInBits += 8 * this.destinationAddress.length;
        }
        lengthInBits += 8;
        return lengthInBits += this.apdu.getLengthInBits();
    }

    public static LDataFrame.LDataFrameBuilder staticParseLDataFrameBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("LDataExtended", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        boolean groupAddress = FieldReaderFactory.readSimpleField("groupAddress", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte hopCount = FieldReaderFactory.readSimpleField("hopCount", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
        byte extendedFrameFormat = FieldReaderFactory.readSimpleField("extendedFrameFormat", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        KnxAddress sourceAddress = FieldReaderFactory.readSimpleField("sourceAddress", new DataReaderComplexDefault<KnxAddress>(() -> KnxAddress.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        byte[] destinationAddress = readBuffer.readByteArray("destinationAddress", Math.toIntExact(2L), new WithReaderArgs[0]);
        short dataLength = FieldReaderFactory.readImplicitField("dataLength", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        Apdu apdu = FieldReaderFactory.readSimpleField("apdu", new DataReaderComplexDefault<Apdu>(() -> Apdu.staticParse(readBuffer, dataLength), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("LDataExtended", new WithReaderArgs[0]);
        return new LDataExtendedBuilderImpl(groupAddress, hopCount, extendedFrameFormat, sourceAddress, destinationAddress, apdu);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LDataExtended)) {
            return false;
        }
        LDataExtended that = (LDataExtended)o;
        return this.getGroupAddress() == that.getGroupAddress() && this.getHopCount() == that.getHopCount() && this.getExtendedFrameFormat() == that.getExtendedFrameFormat() && this.getSourceAddress() == that.getSourceAddress() && this.getDestinationAddress() == that.getDestinationAddress() && this.getApdu() == that.getApdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getGroupAddress(), this.getHopCount(), this.getExtendedFrameFormat(), this.getSourceAddress(), this.getDestinationAddress(), this.getApdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class LDataExtendedBuilderImpl
    implements LDataFrame.LDataFrameBuilder {
        private final boolean groupAddress;
        private final byte hopCount;
        private final byte extendedFrameFormat;
        private final KnxAddress sourceAddress;
        private final byte[] destinationAddress;
        private final Apdu apdu;

        public LDataExtendedBuilderImpl(boolean groupAddress, byte hopCount, byte extendedFrameFormat, KnxAddress sourceAddress, byte[] destinationAddress, Apdu apdu) {
            this.groupAddress = groupAddress;
            this.hopCount = hopCount;
            this.extendedFrameFormat = extendedFrameFormat;
            this.sourceAddress = sourceAddress;
            this.destinationAddress = destinationAddress;
            this.apdu = apdu;
        }

        @Override
        public LDataExtended build(boolean frameType, boolean notRepeated, CEMIPriority priority, boolean acknowledgeRequested, boolean errorFlag) {
            LDataExtended lDataExtended = new LDataExtended(frameType, notRepeated, priority, acknowledgeRequested, errorFlag, this.groupAddress, this.hopCount, this.extendedFrameFormat, this.sourceAddress, this.destinationAddress, this.apdu);
            return lDataExtended;
        }
    }
}

