/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class MACAddress
implements Message {
    protected final byte[] addr;

    public MACAddress(byte[] addr) {
        this.addr = addr;
    }

    public byte[] getAddr() {
        return this.addr;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("MACAddress", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("addr", this.addr, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("MACAddress", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        MACAddress _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.addr != null) {
            lengthInBits += 8 * this.addr.length;
        }
        return lengthInBits;
    }

    public static MACAddress staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return MACAddress.staticParse(readBuffer);
    }

    public static MACAddress staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("MACAddress", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] addr = readBuffer.readByteArray("addr", Math.toIntExact(6L), new WithReaderArgs[0]);
        readBuffer.closeContext("MACAddress", new WithReaderArgs[0]);
        MACAddress _mACAddress = new MACAddress(addr);
        return _mACAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MACAddress)) {
            return false;
        }
        MACAddress that = (MACAddress)o;
        return this.getAddr() == that.getAddr();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAddr()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

