/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.tag;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagCoil;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagDiscreteInput;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagExtendedRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHoldingRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagInputRegister;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class ModbusTag
implements PlcTag,
Serializable {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(:(?<datatype>[a-zA-Z_]+))?(\\[(?<quantity>\\d+)])?");
    public static final Pattern FIXED_DIGIT_MODBUS_PATTERN = Pattern.compile("(?<address>\\d{4,5})?(:(?<datatype>[a-zA-Z_]+))?(\\[(?<quantity>\\d+)])?");
    public static final int PROTOCOL_ADDRESS_OFFSET = 1;
    private final int address;
    private final int quantity;
    private final ModbusDataType dataType;

    public static ModbusTag of(String addressString) {
        if (ModbusTagCoil.matches(addressString)) {
            return ModbusTagCoil.of(addressString);
        }
        if (ModbusTagDiscreteInput.matches(addressString)) {
            return ModbusTagDiscreteInput.of(addressString);
        }
        if (ModbusTagHoldingRegister.matches(addressString)) {
            return ModbusTagHoldingRegister.of(addressString);
        }
        if (ModbusTagInputRegister.matches(addressString)) {
            return ModbusTagInputRegister.of(addressString);
        }
        if (ModbusTagExtendedRegister.matches(addressString)) {
            return ModbusTagExtendedRegister.of(addressString);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + addressString);
    }

    @Override
    public String getAddressString() {
        String address = String.format("%s%05d", this.getAddressStringPrefix(), this.getLogicalAddress());
        if (this.getDataType() != null) {
            address = String.valueOf(address) + ":" + this.getDataType().name();
        }
        if (!this.getArrayInfo().isEmpty()) {
            address = String.valueOf(address) + "[" + this.getArrayInfo().get(0).getUpperBound() + "]";
        }
        return address;
    }

    protected abstract String getAddressStringPrefix();

    protected ModbusTag(int address, Integer quantity, ModbusDataType dataType) {
        this.address = address;
        if (this.getLogicalAddress() <= 0) {
            throw new IllegalArgumentException("address must be greater than zero. Was " + this.getLogicalAddress());
        }
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater than zero. Was " + this.quantity);
        }
        this.dataType = dataType != null ? dataType : ModbusDataType.INT;
    }

    public int getAddress() {
        return this.address;
    }

    public abstract int getLogicalAddress();

    public int getNumberOfElements() {
        return this.quantity;
    }

    public int getLengthBytes() {
        return this.quantity * this.dataType.getDataTypeSize();
    }

    public int getLengthWords() {
        return (int)((float)this.quantity * (float)this.dataType.getDataTypeSize() / 2.0f);
    }

    public ModbusDataType getDataType() {
        return this.dataType;
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf(this.dataType.name());
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        if (this.quantity != 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.quantity));
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusTag)) {
            return false;
        }
        ModbusTag that = (ModbusTag)o;
        return this.address == that.address && this.quantity == that.quantity && this.dataType == that.dataType && this.getClass() == that.getClass();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.address, this.quantity, this.dataType});
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " {" + "address=" + this.address + ", quantity=" + this.quantity + ", dataType=" + (Object)((Object)this.dataType) + " }";
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("address", 16, this.address, new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("numberOfElements", 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, dataType, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

