/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, ModbusDataType dataType, Integer numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL) && EvaluationHelper.equals(numberOfValues, 1)) {
            Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 15), (short)0, new WithReaderArgs[0]);
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL)) {
            List<Boolean> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readBoolean(readBuffer), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (boolean _item : _value) {
                value.add(new PlcBOOL(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE) && EvaluationHelper.equals(numberOfValues, 1)) {
            Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE)) {
            List<Boolean> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readBoolean(readBuffer), numberOfValues * 8, new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (boolean _item : _value) {
                value.add(new PlcBOOL(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WORD)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DWORD)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LWORD)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT)) {
            List<Byte> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readSignedByte(readBuffer, 8), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (byte _item : _value) {
                value.add(new PlcSINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT) && EvaluationHelper.equals(numberOfValues, 1)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT)) {
            List<Short> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readSignedShort(readBuffer, 16), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (short _item : _value) {
                value.add(new PlcINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT)) {
            List<Integer> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readSignedInt(readBuffer, 32), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (int _item : _value) {
                value.add(new PlcDINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT)) {
            List<Long> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readSignedLong(readBuffer, 64), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (long _item : _value) {
                value.add(new PlcLINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT)) {
            List<Short> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (short _item : _value) {
                value.add(new PlcUSINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT)) {
            List<Integer> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (int _item : _value) {
                value.add(new PlcUINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT)) {
            List<Long> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (long _item : _value) {
                value.add(new PlcUDINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT)) {
            List<BigInteger> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (BigInteger _item : _value) {
                value.add(new PlcULINT(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), new WithReaderArgs[0]).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL)) {
            List<Float> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readFloat(readBuffer, 32), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (float _item : _value) {
                value.add(new PlcREAL(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL)) {
            List<Double> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readDouble(readBuffer, 64), numberOfValues.intValue(), new WithReaderArgs[0]);
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (double _item : _value) {
                value.add(new PlcLREAL(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 8), WithOption.WithEncoding("UTF-8"));
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR)) {
            List<String> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readString(readBuffer, 8), numberOfValues.intValue(), WithOption.WithEncoding("UTF-8"));
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (String _item : _value) {
                value.add(new PlcSTRING(_item));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            String value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readString(readBuffer, 16), WithOption.WithEncoding("UTF-16"));
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR)) {
            List<String> _value = FieldReaderFactory.readCountArrayField("value", DataReaderFactory.readString(readBuffer, 16), numberOfValues.intValue(), WithOption.WithEncoding("UTF-16"));
            ArrayList<PlcValue> value = new ArrayList<PlcValue>(_value.size());
            for (String _item : _value) {
                value.add(new PlcSTRING(_item));
            }
            return new PlcList(value);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, ModbusDataType dataType, Integer numberOfValues) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, numberOfValues) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, ModbusDataType dataType, Integer numberOfValues) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 15;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL)) {
            if (_value != null) {
                lengthInBits += 1 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 8;
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE)) {
            if (_value != null) {
                lengthInBits += 1 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WORD)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DWORD)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LWORD)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 8;
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT)) {
            if (_value != null) {
                lengthInBits += 16 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT)) {
            if (_value != null) {
                lengthInBits += 32 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT)) {
            if (_value != null) {
                lengthInBits += 64 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 8;
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT)) {
            if (_value != null) {
                lengthInBits += 16 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT)) {
            if (_value != null) {
                lengthInBits += 32 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT)) {
            if (_value != null) {
                lengthInBits += 64 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL)) {
            if (_value != null) {
                lengthInBits += 32 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL)) {
            if (_value != null) {
                lengthInBits += 64 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getList().size();
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR) && _value != null) {
            lengthInBits += 16 * _value.getList().size();
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, ModbusDataType dataType, Integer numberOfValues) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, numberOfValues, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, ModbusDataType dataType, Integer numberOfValues, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 15), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BOOL)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getBoolean).collect(Collectors.toList()), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.BYTE)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getBoolean).collect(Collectors.toList()), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DWORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LWORD)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.SINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getByte).collect(Collectors.toList()), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.INT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getShort).collect(Collectors.toList()), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.DINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getInteger).collect(Collectors.toList()), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getLong).collect(Collectors.toList()), DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.USINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getShort).collect(Collectors.toList()), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getInteger).collect(Collectors.toList()), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.UDINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getLong).collect(Collectors.toList()), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.ULINT)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getBigInteger).collect(Collectors.toList()), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.REAL)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getFloat).collect(Collectors.toList()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.LREAL)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getDouble).collect(Collectors.toList()), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 8), WithOption.WithEncoding("UTF-8"));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.CHAR)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getString).collect(Collectors.toList()), DataWriterFactory.writeString(writeBuffer, 8), WithOption.WithEncoding("UTF-8"));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR) && EvaluationHelper.equals(numberOfValues, 1)) {
            FieldWriterFactory.writeSimpleField("value", _value.getString(), DataWriterFactory.writeString(writeBuffer, 16), WithOption.WithEncoding("UTF-16"));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)ModbusDataType.WCHAR)) {
            FieldWriterFactory.writeSimpleTypeArrayField("value", _value.getList().stream().map(PlcValue::getString).collect(Collectors.toList()), DataWriterFactory.writeString(writeBuffer, 16), WithOption.WithEncoding("UTF-16"));
        }
    }
}

