/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ModbusPDUWriteFileRecordResponseItem
implements Message {
    protected final short referenceType;
    protected final int fileNumber;
    protected final int recordNumber;
    protected final byte[] recordData;

    public ModbusPDUWriteFileRecordResponseItem(short referenceType, int fileNumber, int recordNumber, byte[] recordData) {
        this.referenceType = referenceType;
        this.fileNumber = fileNumber;
        this.recordNumber = recordNumber;
        this.recordData = recordData;
    }

    public short getReferenceType() {
        return this.referenceType;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusPDUWriteFileRecordResponseItem", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("referenceType", this.referenceType, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("fileNumber", this.fileNumber, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("recordNumber", this.recordNumber, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int recordLength = StaticHelper.COUNT(this.getRecordData()) / 2;
        FieldWriterFactory.writeImplicitField("recordLength", recordLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("recordData", this.recordData, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUWriteFileRecordResponseItem", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        ModbusPDUWriteFileRecordResponseItem _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.recordData != null) {
            lengthInBits += 8 * this.recordData.length;
        }
        return lengthInBits;
    }

    public static ModbusPDUWriteFileRecordResponseItem staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ModbusPDUWriteFileRecordResponseItem.staticParse(readBuffer);
    }

    public static ModbusPDUWriteFileRecordResponseItem staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ModbusPDUWriteFileRecordResponseItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short referenceType = FieldReaderFactory.readSimpleField("referenceType", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        int fileNumber = FieldReaderFactory.readSimpleField("fileNumber", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int recordNumber = FieldReaderFactory.readSimpleField("recordNumber", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int recordLength = FieldReaderFactory.readImplicitField("recordLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte[] recordData = readBuffer.readByteArray("recordData", Math.toIntExact(recordLength), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUWriteFileRecordResponseItem", new WithReaderArgs[0]);
        ModbusPDUWriteFileRecordResponseItem _modbusPDUWriteFileRecordResponseItem = new ModbusPDUWriteFileRecordResponseItem(referenceType, fileNumber, recordNumber, recordData);
        return _modbusPDUWriteFileRecordResponseItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUWriteFileRecordResponseItem)) {
            return false;
        }
        ModbusPDUWriteFileRecordResponseItem that = (ModbusPDUWriteFileRecordResponseItem)o;
        return this.getReferenceType() == that.getReferenceType() && this.getFileNumber() == that.getFileNumber() && this.getRecordNumber() == that.getRecordNumber() && this.getRecordData() == that.getRecordData();
    }

    public int hashCode() {
        return Objects.hash(this.getReferenceType(), this.getFileNumber(), this.getRecordNumber(), this.getRecordData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

