/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ModbusRtuADU
extends ModbusADU
implements Message {
    protected final short address;
    protected final ModbusPDU pdu;

    @Override
    public DriverType getDriverType() {
        return DriverType.MODBUS_RTU;
    }

    public ModbusRtuADU(short address, ModbusPDU pdu) {
        this.address = address;
        this.pdu = pdu;
    }

    public short getAddress() {
        return this.address;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    @Override
    protected void serializeModbusADUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusRtuADU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("address", this.address, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeSimpleField("pdu", this.pdu, new DataWriterComplexDefault(writeBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeChecksumField("crc", StaticHelper.rtuCrcCheck(this.address, this.pdu), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        writeBuffer.popContext("ModbusRtuADU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusRtuADU _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.pdu.getLengthInBits();
        return lengthInBits += 16;
    }

    public static ModbusADU.ModbusADUBuilder staticParseModbusADUBuilder(ReadBuffer readBuffer, DriverType driverType, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusRtuADU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short address = FieldReaderFactory.readSimpleField("address", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        ModbusPDU pdu = FieldReaderFactory.readSimpleField("pdu", new DataReaderComplexDefault<ModbusPDU>(() -> ModbusPDU.staticParse(readBuffer, (boolean)response), readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int crc = FieldReaderFactory.readChecksumField("crc", DataReaderFactory.readUnsignedInt(readBuffer, 16), StaticHelper.rtuCrcCheck(address, pdu), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        readBuffer.closeContext("ModbusRtuADU", new WithReaderArgs[0]);
        return new ModbusRtuADUBuilderImpl(address, pdu);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusRtuADU)) {
            return false;
        }
        ModbusRtuADU that = (ModbusRtuADU)o;
        return this.getAddress() == that.getAddress() && this.getPdu() == that.getPdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAddress(), this.getPdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusRtuADUBuilderImpl
    implements ModbusADU.ModbusADUBuilder {
        private final short address;
        private final ModbusPDU pdu;

        public ModbusRtuADUBuilderImpl(short address, ModbusPDU pdu) {
            this.address = address;
            this.pdu = pdu;
        }

        @Override
        public ModbusRtuADU build() {
            ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.address, this.pdu);
            return modbusRtuADU;
        }
    }
}

