/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ModbusTcpADU
extends ModbusADU
implements Message {
    public static final Integer PROTOCOLIDENTIFIER = 0;
    protected final int transactionIdentifier;
    protected final short unitIdentifier;
    protected final ModbusPDU pdu;

    @Override
    public DriverType getDriverType() {
        return DriverType.MODBUS_TCP;
    }

    public ModbusTcpADU(int transactionIdentifier, short unitIdentifier, ModbusPDU pdu) {
        this.transactionIdentifier = transactionIdentifier;
        this.unitIdentifier = unitIdentifier;
        this.pdu = pdu;
    }

    public int getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public short getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    public int getProtocolIdentifier() {
        return PROTOCOLIDENTIFIER;
    }

    @Override
    protected void serializeModbusADUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusTcpADU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("transactionIdentifier", this.transactionIdentifier, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeConstField("protocolIdentifier", PROTOCOLIDENTIFIER, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int length = this.getPdu().getLengthInBytes() + 1;
        FieldWriterFactory.writeImplicitField("length", length, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeSimpleField("unitIdentifier", this.unitIdentifier, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeSimpleField("pdu", this.pdu, new DataWriterComplexDefault(writeBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        writeBuffer.popContext("ModbusTcpADU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusTcpADU _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += this.pdu.getLengthInBits();
    }

    public static ModbusADU.ModbusADUBuilder staticParseModbusADUBuilder(ReadBuffer readBuffer, DriverType driverType, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusTcpADU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int transactionIdentifier = FieldReaderFactory.readSimpleField("transactionIdentifier", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int protocolIdentifier = FieldReaderFactory.readConstField("protocolIdentifier", DataReaderFactory.readUnsignedInt(readBuffer, 16), PROTOCOLIDENTIFIER, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int length = FieldReaderFactory.readImplicitField("length", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        short unitIdentifier = FieldReaderFactory.readSimpleField("unitIdentifier", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        ModbusPDU pdu = FieldReaderFactory.readSimpleField("pdu", new DataReaderComplexDefault<ModbusPDU>(() -> ModbusPDU.staticParse(readBuffer, (boolean)response), readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        readBuffer.closeContext("ModbusTcpADU", new WithReaderArgs[0]);
        return new ModbusTcpADUBuilderImpl(transactionIdentifier, unitIdentifier, pdu);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusTcpADU)) {
            return false;
        }
        ModbusTcpADU that = (ModbusTcpADU)o;
        return this.getTransactionIdentifier() == that.getTransactionIdentifier() && this.getUnitIdentifier() == that.getUnitIdentifier() && this.getPdu() == that.getPdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTransactionIdentifier(), this.getUnitIdentifier(), this.getPdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusTcpADUBuilderImpl
    implements ModbusADU.ModbusADUBuilder {
        private final int transactionIdentifier;
        private final short unitIdentifier;
        private final ModbusPDU pdu;

        public ModbusTcpADUBuilderImpl(int transactionIdentifier, short unitIdentifier, ModbusPDU pdu) {
            this.transactionIdentifier = transactionIdentifier;
            this.unitIdentifier = unitIdentifier;
            this.pdu = pdu;
        }

        @Override
        public ModbusTcpADU build() {
            ModbusTcpADU modbusTcpADU = new ModbusTcpADU(this.transactionIdentifier, this.unitIdentifier, this.pdu);
            return modbusTcpADU;
        }
    }
}

