/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.rtu.protocol;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcPingRequest;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.protocol.ModbusProtocolLogic;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleCoilResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusRtuADU;
import org.apache.plc4x.java.modbus.rtu.config.ModbusRtuConfiguration;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusRtuProtocolLogic
extends ModbusProtocolLogic<ModbusRtuADU>
implements HasConfiguration<ModbusRtuConfiguration> {
    public ModbusRtuProtocolLogic() {
        super(DriverType.MODBUS_RTU);
    }

    @Override
    public void setConfiguration(ModbusRtuConfiguration configuration) {
        this.requestTimeout = Duration.ofMillis(configuration.getRequestTimeout());
        this.unitIdentifier = (short)configuration.getUnitIdentifier();
        this.tm = new RequestTransactionManager(1);
    }

    @Override
    public void close(ConversationContext<ModbusRtuADU> context) {
        this.tm.shutdown();
    }

    @Override
    public CompletableFuture<PlcPingResponse> ping(PlcPingRequest pingRequest) {
        CompletableFuture<PlcPingResponse> future = new CompletableFuture<PlcPingResponse>();
        ModbusPDU readRequestPdu = this.getReadRequestPdu(this.pingAddress);
        ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.unitIdentifier, readRequestPdu);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.context.sendRequest(modbusRtuADU).expectResponse(ModbusRtuADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                boolean bl = future.completeExceptionally((Throwable)e);
            }).unwrap(ModbusRtuADU::getPdu).handle(responsePdu -> {
                transaction.endRequest();
                future.complete(new DefaultPlcPingResponse(pingRequest, PlcResponseCode.OK));
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        if (request.getTagNames().size() == 1) {
            String tagName = (String)request.getTagNames().iterator().next();
            ModbusTag tag = (ModbusTag)request.getTag(tagName);
            ModbusPDU requestPdu = this.getReadRequestPdu(tag);
            ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(modbusRtuADU).expectResponse(ModbusRtuADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).unwrap(ModbusRtuADU::getPdu).handle(responsePdu -> {
                    PlcResponseCode responseCode;
                    PlcValue plcValue = null;
                    if (responsePdu instanceof ModbusPDUError) {
                        ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                        responseCode = this.getErrorCode(errorResponse);
                    } else {
                        try {
                            plcValue = this.toPlcValue(requestPdu, (ModbusPDU)responsePdu, tag.getDataType());
                            responseCode = PlcResponseCode.OK;
                        }
                        catch (ParseException e) {
                            responseCode = PlcResponseCode.INTERNAL_ERROR;
                        }
                    }
                    DefaultPlcReadResponse response = new DefaultPlcReadResponse(request, Collections.singletonMap(tagName, new ResponseItem<PlcValue>(responseCode, plcValue)));
                    future.complete(response);
                    transaction.endRequest();
                });
            });
        } else {
            future.completeExceptionally(new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        if (request.getTagNames().size() == 1) {
            String tagName = (String)request.getTagNames().iterator().next();
            PlcTag tag = request.getTag(tagName);
            ModbusPDU requestPdu = this.getWriteRequestPdu(tag, writeRequest.getPlcValue(tagName));
            ModbusRtuADU modbusRtuADU = new ModbusRtuADU(this.unitIdentifier, requestPdu);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.context.sendRequest(modbusRtuADU).expectResponse(ModbusRtuADU.class, this.requestTimeout).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).unwrap(ModbusRtuADU::getPdu).handle(responsePdu -> {
                    Serializable response;
                    PlcResponseCode responseCode;
                    if (responsePdu instanceof ModbusPDUError) {
                        ModbusPDUError errorResponse = (ModbusPDUError)responsePdu;
                        responseCode = this.getErrorCode(errorResponse);
                    } else {
                        responseCode = PlcResponseCode.OK;
                        if (responsePdu instanceof ModbusPDUWriteSingleCoilResponse) {
                            response = (ModbusPDUWriteSingleCoilResponse)responsePdu;
                            ModbusPDUWriteSingleCoilRequest requestSingleCoil = (ModbusPDUWriteSingleCoilRequest)requestPdu;
                            if (((ModbusPDUWriteSingleCoilResponse)response).getValue() != requestSingleCoil.getValue() || ((ModbusPDUWriteSingleCoilResponse)response).getAddress() != requestSingleCoil.getAddress()) {
                                responseCode = PlcResponseCode.REMOTE_ERROR;
                            }
                        }
                    }
                    response = new DefaultPlcWriteResponse(request, Collections.singletonMap(tagName, responseCode));
                    future.complete((PlcWriteResponse)((Object)response));
                    transaction.endRequest();
                });
            });
        } else {
            future.completeExceptionally(new PlcRuntimeException("Modbus only supports single filed requests"));
        }
        return future;
    }

    @Override
    protected void decode(ConversationContext<ModbusRtuADU> context, ModbusRtuADU msg) throws Exception {
        System.out.println(msg);
    }
}

