/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.CertificateGenerator;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.security.CertificateVerifier;
import org.apache.plc4x.java.opcua.security.PermissiveCertificateVerifier;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.opcua.security.TrustStoreCertificateVerifier;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaDriverContext
implements DriverContext,
HasConfiguration<OpcuaConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaDriverContext.class);
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("(:(?<transportCode>[a-z0-9]*))?://(?<transportHost>[\\w.-]+)(:(?<transportPort>\\d*))?");
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>opcua)" + INET_ADDRESS_PATTERN + "(?<transportEndpoint>[\\w/=]*)[?]?" + "(?<paramString>([^=]+=[^=&]+&?)*)");
    private String code;
    private String host;
    private String port;
    private String endpoint;
    private String transportEndpoint;
    private CertificateKeyPair certificateKeyPair;
    private X509Certificate serverCertificate;
    private PascalByteString thumbprint;
    private CertificateVerifier certificateVerifier = new PermissiveCertificateVerifier();

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public void openKeyStore(OpcuaConfiguration configuration) throws IOException, GeneralSecurityException {
        String serverKeyStore = configuration.getKeyStoreFile();
        if (serverKeyStore == null) {
            LOGGER.info("Client certificate not provided, creating temporary certificate and private key");
            this.certificateKeyPair = CertificateGenerator.generateCertificate();
        } else {
            LOGGER.info("Loading KeyStore at {}", (Object)serverKeyStore);
            KeyStore keyStore = OpcuaDriverContext.openKeyStore(configuration.getKeyStoreFile(), configuration.getKeyStoreType(), configuration.getKeyStorePassword());
            String alias = keyStore.aliases().nextElement();
            KeyPair kp = new KeyPair(keyStore.getCertificate(alias).getPublicKey(), (PrivateKey)keyStore.getKey(alias, configuration.getKeyStorePassword()));
            this.certificateKeyPair = new CertificateKeyPair(kp, (X509Certificate)keyStore.getCertificate(alias));
        }
        if (configuration.getServerCertificate() != null) {
            this.serverCertificate = configuration.getServerCertificate();
            byte[] sha1 = DigestUtils.sha1(this.serverCertificate.getEncoded());
            this.thumbprint = new PascalByteString(sha1.length, sha1);
        }
        if (configuration.getTrustStoreFile() != null) {
            KeyStore trustStore = OpcuaDriverContext.openKeyStore(configuration.getTrustStoreFile(), configuration.getTrustStoreType(), configuration.getTrustStorePassword());
            this.certificateVerifier = new TrustStoreCertificateVerifier(trustStore);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getTransportEndpoint() {
        return this.transportEndpoint;
    }

    public void setTransportEndpoint(String transportEndpoint) {
        this.transportEndpoint = transportEndpoint;
    }

    public X509Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public CertificateKeyPair getCertificateKeyPair() {
        return this.certificateKeyPair;
    }

    @Override
    public void setConfiguration(OpcuaConfiguration configuration) {
        Matcher matcher = OpcuaDriverContext.getMatcher(configuration);
        this.code = matcher.group("transportCode");
        this.host = matcher.group("transportHost");
        this.port = matcher.group("transportPort");
        this.transportEndpoint = matcher.group("transportEndpoint");
        String portAddition = this.port != null ? ":" + this.port : "";
        this.endpoint = "opc." + this.code + "://" + this.host + portAddition + this.transportEndpoint;
        if (configuration.getSecurityPolicy() != null && configuration.getSecurityPolicy() != SecurityPolicy.NONE) {
            try {
                this.openKeyStore(configuration);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new PlcRuntimeException("Unable to open keystore, please confirm you have the correct permissions", e);
            }
        }
    }

    private static Matcher getMatcher(OpcuaConfiguration configuration) {
        String uri = String.valueOf(configuration.getProtocolCode()) + ":" + configuration.getTransportCode() + "://" + configuration.getTransportConfig();
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-host}(:{transport-port})(/{transport-endpoint})(?{parameter-string)?': " + uri);
        }
        return matcher;
    }

    public Optional<String> getApplicationUri() {
        return Optional.ofNullable(this.certificateKeyPair).flatMap(CertificateKeyPair::getApplicationUri);
    }

    public PascalByteString getThumbprint() {
        return this.thumbprint;
    }

    public CertificateVerifier getCertificateVerifier() {
        return this.certificateVerifier;
    }

    private static KeyStore openKeyStore(String keyStoreFile, String keyStoreType, char[] password) throws IOException, GeneralSecurityException {
        File serverKeyStore = null;
        if (keyStoreFile != null) {
            serverKeyStore = Paths.get(keyStoreFile, new String[0]).toFile();
        }
        if (keyStoreFile == null || !serverKeyStore.exists()) {
            throw new FileNotFoundException("Invalid parameter - specified file " + keyStoreFile + " does not exist");
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(serverKeyStore), password);
        return keyStore;
    }
}

