/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AddReferencesRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfReferencesToAdd;
    protected final List<ExtensionObjectDefinition> referencesToAdd;

    @Override
    public String getIdentifier() {
        return "494";
    }

    public AddReferencesRequest(ExtensionObjectDefinition requestHeader, int noOfReferencesToAdd, List<ExtensionObjectDefinition> referencesToAdd) {
        this.requestHeader = requestHeader;
        this.noOfReferencesToAdd = noOfReferencesToAdd;
        this.referencesToAdd = referencesToAdd;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfReferencesToAdd() {
        return this.noOfReferencesToAdd;
    }

    public List<ExtensionObjectDefinition> getReferencesToAdd() {
        return this.referencesToAdd;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AddReferencesRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfReferencesToAdd", this.noOfReferencesToAdd, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("referencesToAdd", this.referencesToAdd, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("AddReferencesRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AddReferencesRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.referencesToAdd != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.referencesToAdd) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.referencesToAdd.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("AddReferencesRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        int noOfReferencesToAdd = FieldReaderFactory.readSimpleField("noOfReferencesToAdd", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> referencesToAdd = FieldReaderFactory.readCountArrayField("referencesToAdd", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "381"), readBuffer), noOfReferencesToAdd, new WithReaderArgs[0]);
        readBuffer.closeContext("AddReferencesRequest", new WithReaderArgs[0]);
        return new AddReferencesRequestBuilderImpl(requestHeader, noOfReferencesToAdd, referencesToAdd);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddReferencesRequest)) {
            return false;
        }
        AddReferencesRequest that = (AddReferencesRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfReferencesToAdd() == that.getNoOfReferencesToAdd() && this.getReferencesToAdd() == that.getReferencesToAdd() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfReferencesToAdd(), this.getReferencesToAdd());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AddReferencesRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfReferencesToAdd;
        private final List<ExtensionObjectDefinition> referencesToAdd;

        public AddReferencesRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfReferencesToAdd, List<ExtensionObjectDefinition> referencesToAdd) {
            this.requestHeader = requestHeader;
            this.noOfReferencesToAdd = noOfReferencesToAdd;
            this.referencesToAdd = referencesToAdd;
        }

        @Override
        public AddReferencesRequest build() {
            AddReferencesRequest addReferencesRequest = new AddReferencesRequest(this.requestHeader, this.noOfReferencesToAdd, this.referencesToAdd);
            return addReferencesRequest;
        }
    }
}

