/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.AxisScaleEnumeration;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class AxisInformation
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition engineeringUnits;
    protected final ExtensionObjectDefinition eURange;
    protected final LocalizedText title;
    protected final AxisScaleEnumeration axisScaleType;
    protected final int noOfAxisSteps;
    protected final List<Double> axisSteps;

    @Override
    public String getIdentifier() {
        return "12081";
    }

    public AxisInformation(ExtensionObjectDefinition engineeringUnits, ExtensionObjectDefinition eURange, LocalizedText title, AxisScaleEnumeration axisScaleType, int noOfAxisSteps, List<Double> axisSteps) {
        this.engineeringUnits = engineeringUnits;
        this.eURange = eURange;
        this.title = title;
        this.axisScaleType = axisScaleType;
        this.noOfAxisSteps = noOfAxisSteps;
        this.axisSteps = axisSteps;
    }

    public ExtensionObjectDefinition getEngineeringUnits() {
        return this.engineeringUnits;
    }

    public ExtensionObjectDefinition getEURange() {
        return this.eURange;
    }

    public LocalizedText getTitle() {
        return this.title;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this.axisScaleType;
    }

    public int getNoOfAxisSteps() {
        return this.noOfAxisSteps;
    }

    public List<Double> getAxisSteps() {
        return this.axisSteps;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AxisInformation", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("engineeringUnits", this.engineeringUnits, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("eURange", this.eURange, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("title", this.title, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("axisScaleType", "AxisScaleEnumeration", this.axisScaleType, new DataWriterEnumDefault<AxisScaleEnumeration, Long>(AxisScaleEnumeration::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfAxisSteps", this.noOfAxisSteps, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("axisSteps", this.axisSteps, DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        writeBuffer.popContext("AxisInformation", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AxisInformation _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.engineeringUnits.getLengthInBits();
        lengthInBits += this.eURange.getLengthInBits();
        lengthInBits += this.title.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.axisSteps != null) {
            lengthInBits += 64 * this.axisSteps.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("AxisInformation", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition engineeringUnits = FieldReaderFactory.readSimpleField("engineeringUnits", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "889"), readBuffer), new WithReaderArgs[0]);
        ExtensionObjectDefinition eURange = FieldReaderFactory.readSimpleField("eURange", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "886"), readBuffer), new WithReaderArgs[0]);
        LocalizedText title = FieldReaderFactory.readSimpleField("title", new DataReaderComplexDefault<LocalizedText>(() -> LocalizedText.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        AxisScaleEnumeration axisScaleType = (AxisScaleEnumeration)((Object)FieldReaderFactory.readEnumField("axisScaleType", "AxisScaleEnumeration", new DataReaderEnumDefault<AxisScaleEnumeration, Long>(AxisScaleEnumeration::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        int noOfAxisSteps = FieldReaderFactory.readSimpleField("noOfAxisSteps", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Double> axisSteps = FieldReaderFactory.readCountArrayField("axisSteps", DataReaderFactory.readDouble(readBuffer, 64), noOfAxisSteps, new WithReaderArgs[0]);
        readBuffer.closeContext("AxisInformation", new WithReaderArgs[0]);
        return new AxisInformationBuilderImpl(engineeringUnits, eURange, title, axisScaleType, noOfAxisSteps, axisSteps);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AxisInformation)) {
            return false;
        }
        AxisInformation that = (AxisInformation)o;
        return this.getEngineeringUnits() == that.getEngineeringUnits() && this.getEURange() == that.getEURange() && this.getTitle() == that.getTitle() && this.getAxisScaleType() == that.getAxisScaleType() && this.getNoOfAxisSteps() == that.getNoOfAxisSteps() && this.getAxisSteps() == that.getAxisSteps() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getEngineeringUnits(), this.getEURange(), this.getTitle(), this.getAxisScaleType(), this.getNoOfAxisSteps(), this.getAxisSteps()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AxisInformationBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition engineeringUnits;
        private final ExtensionObjectDefinition eURange;
        private final LocalizedText title;
        private final AxisScaleEnumeration axisScaleType;
        private final int noOfAxisSteps;
        private final List<Double> axisSteps;

        public AxisInformationBuilderImpl(ExtensionObjectDefinition engineeringUnits, ExtensionObjectDefinition eURange, LocalizedText title, AxisScaleEnumeration axisScaleType, int noOfAxisSteps, List<Double> axisSteps) {
            this.engineeringUnits = engineeringUnits;
            this.eURange = eURange;
            this.title = title;
            this.axisScaleType = axisScaleType;
            this.noOfAxisSteps = noOfAxisSteps;
            this.axisSteps = axisSteps;
        }

        @Override
        public AxisInformation build() {
            AxisInformation axisInformation = new AxisInformation(this.engineeringUnits, this.eURange, this.title, this.axisScaleType, this.noOfAxisSteps, this.axisSteps);
            return axisInformation;
        }
    }
}

