/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class BrowsePathTarget
extends ExtensionObjectDefinition
implements Message {
    protected final ExpandedNodeId targetId;
    protected final long remainingPathIndex;

    @Override
    public String getIdentifier() {
        return "548";
    }

    public BrowsePathTarget(ExpandedNodeId targetId, long remainingPathIndex) {
        this.targetId = targetId;
        this.remainingPathIndex = remainingPathIndex;
    }

    public ExpandedNodeId getTargetId() {
        return this.targetId;
    }

    public long getRemainingPathIndex() {
        return this.remainingPathIndex;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowsePathTarget", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("targetId", this.targetId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("remainingPathIndex", this.remainingPathIndex, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("BrowsePathTarget", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowsePathTarget _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.targetId.getLengthInBits();
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BrowsePathTarget", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExpandedNodeId targetId = FieldReaderFactory.readSimpleField("targetId", new DataReaderComplexDefault<ExpandedNodeId>(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long remainingPathIndex = FieldReaderFactory.readSimpleField("remainingPathIndex", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("BrowsePathTarget", new WithReaderArgs[0]);
        return new BrowsePathTargetBuilderImpl(targetId, remainingPathIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowsePathTarget)) {
            return false;
        }
        BrowsePathTarget that = (BrowsePathTarget)o;
        return this.getTargetId() == that.getTargetId() && this.getRemainingPathIndex() == that.getRemainingPathIndex() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTargetId(), this.getRemainingPathIndex());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowsePathTargetBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExpandedNodeId targetId;
        private final long remainingPathIndex;

        public BrowsePathTargetBuilderImpl(ExpandedNodeId targetId, long remainingPathIndex) {
            this.targetId = targetId;
            this.remainingPathIndex = remainingPathIndex;
        }

        @Override
        public BrowsePathTarget build() {
            BrowsePathTarget browsePathTarget = new BrowsePathTarget(this.targetId, this.remainingPathIndex);
            return browsePathTarget;
        }
    }
}

