/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class BrowseRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final ExtensionObjectDefinition view;
    protected final long requestedMaxReferencesPerNode;
    protected final int noOfNodesToBrowse;
    protected final List<ExtensionObjectDefinition> nodesToBrowse;

    @Override
    public String getIdentifier() {
        return "527";
    }

    public BrowseRequest(ExtensionObjectDefinition requestHeader, ExtensionObjectDefinition view, long requestedMaxReferencesPerNode, int noOfNodesToBrowse, List<ExtensionObjectDefinition> nodesToBrowse) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
        this.noOfNodesToBrowse = noOfNodesToBrowse;
        this.nodesToBrowse = nodesToBrowse;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObjectDefinition getView() {
        return this.view;
    }

    public long getRequestedMaxReferencesPerNode() {
        return this.requestedMaxReferencesPerNode;
    }

    public int getNoOfNodesToBrowse() {
        return this.noOfNodesToBrowse;
    }

    public List<ExtensionObjectDefinition> getNodesToBrowse() {
        return this.nodesToBrowse;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowseRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("view", this.view, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestedMaxReferencesPerNode", this.requestedMaxReferencesPerNode, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNodesToBrowse", this.noOfNodesToBrowse, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("nodesToBrowse", this.nodesToBrowse, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("BrowseRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowseRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.view.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.nodesToBrowse != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.nodesToBrowse) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToBrowse.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BrowseRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        ExtensionObjectDefinition view = FieldReaderFactory.readSimpleField("view", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "513"), readBuffer), new WithReaderArgs[0]);
        long requestedMaxReferencesPerNode = FieldReaderFactory.readSimpleField("requestedMaxReferencesPerNode", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        int noOfNodesToBrowse = FieldReaderFactory.readSimpleField("noOfNodesToBrowse", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> nodesToBrowse = FieldReaderFactory.readCountArrayField("nodesToBrowse", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "516"), readBuffer), noOfNodesToBrowse, new WithReaderArgs[0]);
        readBuffer.closeContext("BrowseRequest", new WithReaderArgs[0]);
        return new BrowseRequestBuilderImpl(requestHeader, view, requestedMaxReferencesPerNode, noOfNodesToBrowse, nodesToBrowse);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowseRequest)) {
            return false;
        }
        BrowseRequest that = (BrowseRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getView() == that.getView() && this.getRequestedMaxReferencesPerNode() == that.getRequestedMaxReferencesPerNode() && this.getNoOfNodesToBrowse() == that.getNoOfNodesToBrowse() && this.getNodesToBrowse() == that.getNodesToBrowse() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getView(), this.getRequestedMaxReferencesPerNode(), this.getNoOfNodesToBrowse(), this.getNodesToBrowse());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowseRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final ExtensionObjectDefinition view;
        private final long requestedMaxReferencesPerNode;
        private final int noOfNodesToBrowse;
        private final List<ExtensionObjectDefinition> nodesToBrowse;

        public BrowseRequestBuilderImpl(ExtensionObjectDefinition requestHeader, ExtensionObjectDefinition view, long requestedMaxReferencesPerNode, int noOfNodesToBrowse, List<ExtensionObjectDefinition> nodesToBrowse) {
            this.requestHeader = requestHeader;
            this.view = view;
            this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
            this.noOfNodesToBrowse = noOfNodesToBrowse;
            this.nodesToBrowse = nodesToBrowse;
        }

        @Override
        public BrowseRequest build() {
            BrowseRequest browseRequest = new BrowseRequest(this.requestHeader, this.view, this.requestedMaxReferencesPerNode, this.noOfNodesToBrowse, this.nodesToBrowse);
            return browseRequest;
        }
    }
}

