/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CreateSessionRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final ExtensionObjectDefinition clientDescription;
    protected final PascalString serverUri;
    protected final PascalString endpointUrl;
    protected final PascalString sessionName;
    protected final PascalByteString clientNonce;
    protected final PascalByteString clientCertificate;
    protected final double requestedSessionTimeout;
    protected final long maxResponseMessageSize;

    @Override
    public String getIdentifier() {
        return "461";
    }

    public CreateSessionRequest(ExtensionObjectDefinition requestHeader, ExtensionObjectDefinition clientDescription, PascalString serverUri, PascalString endpointUrl, PascalString sessionName, PascalByteString clientNonce, PascalByteString clientCertificate, double requestedSessionTimeout, long maxResponseMessageSize) {
        this.requestHeader = requestHeader;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.endpointUrl = endpointUrl;
        this.sessionName = sessionName;
        this.clientNonce = clientNonce;
        this.clientCertificate = clientCertificate;
        this.requestedSessionTimeout = requestedSessionTimeout;
        this.maxResponseMessageSize = maxResponseMessageSize;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObjectDefinition getClientDescription() {
        return this.clientDescription;
    }

    public PascalString getServerUri() {
        return this.serverUri;
    }

    public PascalString getEndpointUrl() {
        return this.endpointUrl;
    }

    public PascalString getSessionName() {
        return this.sessionName;
    }

    public PascalByteString getClientNonce() {
        return this.clientNonce;
    }

    public PascalByteString getClientCertificate() {
        return this.clientCertificate;
    }

    public double getRequestedSessionTimeout() {
        return this.requestedSessionTimeout;
    }

    public long getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CreateSessionRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientDescription", this.clientDescription, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serverUri", this.serverUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("endpointUrl", this.endpointUrl, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sessionName", this.sessionName, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientNonce", this.clientNonce, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientCertificate", this.clientCertificate, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestedSessionTimeout", this.requestedSessionTimeout, DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("maxResponseMessageSize", this.maxResponseMessageSize, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("CreateSessionRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CreateSessionRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.clientDescription.getLengthInBits();
        lengthInBits += this.serverUri.getLengthInBits();
        lengthInBits += this.endpointUrl.getLengthInBits();
        lengthInBits += this.sessionName.getLengthInBits();
        lengthInBits += this.clientNonce.getLengthInBits();
        lengthInBits += this.clientCertificate.getLengthInBits();
        lengthInBits += 64;
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CreateSessionRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        ExtensionObjectDefinition clientDescription = FieldReaderFactory.readSimpleField("clientDescription", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "310"), readBuffer), new WithReaderArgs[0]);
        PascalString serverUri = FieldReaderFactory.readSimpleField("serverUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString endpointUrl = FieldReaderFactory.readSimpleField("endpointUrl", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString sessionName = FieldReaderFactory.readSimpleField("sessionName", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString clientNonce = FieldReaderFactory.readSimpleField("clientNonce", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString clientCertificate = FieldReaderFactory.readSimpleField("clientCertificate", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        double requestedSessionTimeout = FieldReaderFactory.readSimpleField("requestedSessionTimeout", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
        long maxResponseMessageSize = FieldReaderFactory.readSimpleField("maxResponseMessageSize", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("CreateSessionRequest", new WithReaderArgs[0]);
        return new CreateSessionRequestBuilderImpl(requestHeader, clientDescription, serverUri, endpointUrl, sessionName, clientNonce, clientCertificate, requestedSessionTimeout, maxResponseMessageSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest that = (CreateSessionRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getClientDescription() == that.getClientDescription() && this.getServerUri() == that.getServerUri() && this.getEndpointUrl() == that.getEndpointUrl() && this.getSessionName() == that.getSessionName() && this.getClientNonce() == that.getClientNonce() && this.getClientCertificate() == that.getClientCertificate() && this.getRequestedSessionTimeout() == that.getRequestedSessionTimeout() && this.getMaxResponseMessageSize() == that.getMaxResponseMessageSize() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getClientDescription(), this.getServerUri(), this.getEndpointUrl(), this.getSessionName(), this.getClientNonce(), this.getClientCertificate(), this.getRequestedSessionTimeout(), this.getMaxResponseMessageSize());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CreateSessionRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final ExtensionObjectDefinition clientDescription;
        private final PascalString serverUri;
        private final PascalString endpointUrl;
        private final PascalString sessionName;
        private final PascalByteString clientNonce;
        private final PascalByteString clientCertificate;
        private final double requestedSessionTimeout;
        private final long maxResponseMessageSize;

        public CreateSessionRequestBuilderImpl(ExtensionObjectDefinition requestHeader, ExtensionObjectDefinition clientDescription, PascalString serverUri, PascalString endpointUrl, PascalString sessionName, PascalByteString clientNonce, PascalByteString clientCertificate, double requestedSessionTimeout, long maxResponseMessageSize) {
            this.requestHeader = requestHeader;
            this.clientDescription = clientDescription;
            this.serverUri = serverUri;
            this.endpointUrl = endpointUrl;
            this.sessionName = sessionName;
            this.clientNonce = clientNonce;
            this.clientCertificate = clientCertificate;
            this.requestedSessionTimeout = requestedSessionTimeout;
            this.maxResponseMessageSize = maxResponseMessageSize;
        }

        @Override
        public CreateSessionRequest build() {
            CreateSessionRequest createSessionRequest = new CreateSessionRequest(this.requestHeader, this.clientDescription, this.serverUri, this.endpointUrl, this.sessionName, this.clientNonce, this.clientCertificate, this.requestedSessionTimeout, this.maxResponseMessageSize);
            return createSessionRequest;
        }
    }
}

