/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CurrencyUnitType
extends ExtensionObjectDefinition
implements Message {
    protected final short numericCode;
    protected final byte exponent;
    protected final PascalString alphabeticCode;
    protected final LocalizedText currency;

    @Override
    public String getIdentifier() {
        return "23500";
    }

    public CurrencyUnitType(short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {
        this.numericCode = numericCode;
        this.exponent = exponent;
        this.alphabeticCode = alphabeticCode;
        this.currency = currency;
    }

    public short getNumericCode() {
        return this.numericCode;
    }

    public byte getExponent() {
        return this.exponent;
    }

    public PascalString getAlphabeticCode() {
        return this.alphabeticCode;
    }

    public LocalizedText getCurrency() {
        return this.currency;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CurrencyUnitType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("numericCode", this.numericCode, DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("exponent", this.exponent, DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("alphabeticCode", this.alphabeticCode, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("currency", this.currency, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("CurrencyUnitType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CurrencyUnitType _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += this.alphabeticCode.getLengthInBits();
        return lengthInBits += this.currency.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CurrencyUnitType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short numericCode = FieldReaderFactory.readSimpleField("numericCode", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
        byte exponent = FieldReaderFactory.readSimpleField("exponent", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
        PascalString alphabeticCode = FieldReaderFactory.readSimpleField("alphabeticCode", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        LocalizedText currency = FieldReaderFactory.readSimpleField("currency", new DataReaderComplexDefault<LocalizedText>(() -> LocalizedText.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("CurrencyUnitType", new WithReaderArgs[0]);
        return new CurrencyUnitTypeBuilderImpl(numericCode, exponent, alphabeticCode, currency);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrencyUnitType)) {
            return false;
        }
        CurrencyUnitType that = (CurrencyUnitType)o;
        return this.getNumericCode() == that.getNumericCode() && this.getExponent() == that.getExponent() && this.getAlphabeticCode() == that.getAlphabeticCode() && this.getCurrency() == that.getCurrency() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumericCode(), this.getExponent(), this.getAlphabeticCode(), this.getCurrency());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CurrencyUnitTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final short numericCode;
        private final byte exponent;
        private final PascalString alphabeticCode;
        private final LocalizedText currency;

        public CurrencyUnitTypeBuilderImpl(short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {
            this.numericCode = numericCode;
            this.exponent = exponent;
            this.alphabeticCode = alphabeticCode;
            this.currency = currency;
        }

        @Override
        public CurrencyUnitType build() {
            CurrencyUnitType currencyUnitType = new CurrencyUnitType(this.numericCode, this.exponent, this.alphabeticCode, this.currency);
            return currencyUnitType;
        }
    }
}

