/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class DataChangeNotification
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfMonitoredItems;
    protected final List<ExtensionObjectDefinition> monitoredItems;
    protected final int noOfDiagnosticInfos;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public String getIdentifier() {
        return "811";
    }

    public DataChangeNotification(int noOfMonitoredItems, List<ExtensionObjectDefinition> monitoredItems, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
        this.noOfMonitoredItems = noOfMonitoredItems;
        this.monitoredItems = monitoredItems;
        this.noOfDiagnosticInfos = noOfDiagnosticInfos;
        this.diagnosticInfos = diagnosticInfos;
    }

    public int getNoOfMonitoredItems() {
        return this.noOfMonitoredItems;
    }

    public List<ExtensionObjectDefinition> getMonitoredItems() {
        return this.monitoredItems;
    }

    public int getNoOfDiagnosticInfos() {
        return this.noOfDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DataChangeNotification", new WithWriterArgs[0]);
        int notificationLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField("notificationLength", notificationLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfMonitoredItems", this.noOfMonitoredItems, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("monitoredItems", this.monitoredItems, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDiagnosticInfos", this.noOfDiagnosticInfos, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("diagnosticInfos", this.diagnosticInfos, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("DataChangeNotification", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        DataChangeNotification _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.monitoredItems != null) {
            i = 0;
            for (ExtensionObjectDefinition extensionObjectDefinition : this.monitoredItems) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.monitoredItems.size());
                lengthInBits += extensionObjectDefinition.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("DataChangeNotification", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int notificationLength = FieldReaderFactory.readImplicitField("notificationLength", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        int noOfMonitoredItems = FieldReaderFactory.readSimpleField("noOfMonitoredItems", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> monitoredItems = FieldReaderFactory.readCountArrayField("monitoredItems", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "808"), readBuffer), noOfMonitoredItems, new WithReaderArgs[0]);
        int noOfDiagnosticInfos = FieldReaderFactory.readSimpleField("noOfDiagnosticInfos", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DiagnosticInfo> diagnosticInfos = FieldReaderFactory.readCountArrayField("diagnosticInfos", new DataReaderComplexDefault<DiagnosticInfo>(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), noOfDiagnosticInfos, new WithReaderArgs[0]);
        readBuffer.closeContext("DataChangeNotification", new WithReaderArgs[0]);
        return new DataChangeNotificationBuilderImpl(noOfMonitoredItems, monitoredItems, noOfDiagnosticInfos, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeNotification)) {
            return false;
        }
        DataChangeNotification that = (DataChangeNotification)o;
        return this.getNoOfMonitoredItems() == that.getNoOfMonitoredItems() && this.getMonitoredItems() == that.getMonitoredItems() && this.getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfMonitoredItems(), this.getMonitoredItems(), this.getNoOfDiagnosticInfos(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataChangeNotificationBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfMonitoredItems;
        private final List<ExtensionObjectDefinition> monitoredItems;
        private final int noOfDiagnosticInfos;
        private final List<DiagnosticInfo> diagnosticInfos;

        public DataChangeNotificationBuilderImpl(int noOfMonitoredItems, List<ExtensionObjectDefinition> monitoredItems, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
            this.noOfMonitoredItems = noOfMonitoredItems;
            this.monitoredItems = monitoredItems;
            this.noOfDiagnosticInfos = noOfDiagnosticInfos;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public DataChangeNotification build() {
            DataChangeNotification dataChangeNotification = new DataChangeNotification(this.noOfMonitoredItems, this.monitoredItems, this.noOfDiagnosticInfos, this.diagnosticInfos);
            return dataChangeNotification;
        }
    }
}

