/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class DeleteSubscriptionsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfSubscriptionIds;
    protected final List<Long> subscriptionIds;

    @Override
    public String getIdentifier() {
        return "847";
    }

    public DeleteSubscriptionsRequest(ExtensionObjectDefinition requestHeader, int noOfSubscriptionIds, List<Long> subscriptionIds) {
        this.requestHeader = requestHeader;
        this.noOfSubscriptionIds = noOfSubscriptionIds;
        this.subscriptionIds = subscriptionIds;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfSubscriptionIds() {
        return this.noOfSubscriptionIds;
    }

    public List<Long> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DeleteSubscriptionsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfSubscriptionIds", this.noOfSubscriptionIds, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("subscriptionIds", this.subscriptionIds, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("DeleteSubscriptionsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DeleteSubscriptionsRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.subscriptionIds != null) {
            lengthInBits += 32 * this.subscriptionIds.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("DeleteSubscriptionsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        int noOfSubscriptionIds = FieldReaderFactory.readSimpleField("noOfSubscriptionIds", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Long> subscriptionIds = FieldReaderFactory.readCountArrayField("subscriptionIds", DataReaderFactory.readUnsignedLong(readBuffer, 32), noOfSubscriptionIds, new WithReaderArgs[0]);
        readBuffer.closeContext("DeleteSubscriptionsRequest", new WithReaderArgs[0]);
        return new DeleteSubscriptionsRequestBuilderImpl(requestHeader, noOfSubscriptionIds, subscriptionIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteSubscriptionsRequest)) {
            return false;
        }
        DeleteSubscriptionsRequest that = (DeleteSubscriptionsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfSubscriptionIds() == that.getNoOfSubscriptionIds() && this.getSubscriptionIds() == that.getSubscriptionIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfSubscriptionIds(), this.getSubscriptionIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DeleteSubscriptionsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfSubscriptionIds;
        private final List<Long> subscriptionIds;

        public DeleteSubscriptionsRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfSubscriptionIds, List<Long> subscriptionIds) {
            this.requestHeader = requestHeader;
            this.noOfSubscriptionIds = noOfSubscriptionIds;
            this.subscriptionIds = subscriptionIds;
        }

        @Override
        public DeleteSubscriptionsRequest build() {
            DeleteSubscriptionsRequest deleteSubscriptionsRequest = new DeleteSubscriptionsRequest(this.requestHeader, this.noOfSubscriptionIds, this.subscriptionIds);
            return deleteSubscriptionsRequest;
        }
    }
}

