/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class EndpointType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString endpointUrl;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityPolicyUri;
    protected final PascalString transportProfileUri;

    @Override
    public String getIdentifier() {
        return "15530";
    }

    public EndpointType(PascalString endpointUrl, MessageSecurityMode securityMode, PascalString securityPolicyUri, PascalString transportProfileUri) {
        this.endpointUrl = endpointUrl;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.transportProfileUri = transportProfileUri;
    }

    public PascalString getEndpointUrl() {
        return this.endpointUrl;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public PascalString getTransportProfileUri() {
        return this.transportProfileUri;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EndpointType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("endpointUrl", this.endpointUrl, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("securityMode", "MessageSecurityMode", this.securityMode, new DataWriterEnumDefault<MessageSecurityMode, Long>(MessageSecurityMode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("securityPolicyUri", this.securityPolicyUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("transportProfileUri", this.transportProfileUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("EndpointType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EndpointType _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.endpointUrl.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.securityPolicyUri.getLengthInBits();
        return lengthInBits += this.transportProfileUri.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("EndpointType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString endpointUrl = FieldReaderFactory.readSimpleField("endpointUrl", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField("securityMode", "MessageSecurityMode", new DataReaderEnumDefault<MessageSecurityMode, Long>(MessageSecurityMode::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        PascalString securityPolicyUri = FieldReaderFactory.readSimpleField("securityPolicyUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString transportProfileUri = FieldReaderFactory.readSimpleField("transportProfileUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("EndpointType", new WithReaderArgs[0]);
        return new EndpointTypeBuilderImpl(endpointUrl, securityMode, securityPolicyUri, transportProfileUri);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointType)) {
            return false;
        }
        EndpointType that = (EndpointType)o;
        return this.getEndpointUrl() == that.getEndpointUrl() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityPolicyUri() == that.getSecurityPolicyUri() && this.getTransportProfileUri() == that.getTransportProfileUri() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getEndpointUrl(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getTransportProfileUri()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EndpointTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString endpointUrl;
        private final MessageSecurityMode securityMode;
        private final PascalString securityPolicyUri;
        private final PascalString transportProfileUri;

        public EndpointTypeBuilderImpl(PascalString endpointUrl, MessageSecurityMode securityMode, PascalString securityPolicyUri, PascalString transportProfileUri) {
            this.endpointUrl = endpointUrl;
            this.securityMode = securityMode;
            this.securityPolicyUri = securityPolicyUri;
            this.transportProfileUri = transportProfileUri;
        }

        @Override
        public EndpointType build() {
            EndpointType endpointType = new EndpointType(this.endpointUrl, this.securityMode, this.securityPolicyUri, this.transportProfileUri);
            return endpointType;
        }
    }
}

