/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class EventNotificationList
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfEvents;
    protected final List<ExtensionObjectDefinition> events;

    @Override
    public String getIdentifier() {
        return "916";
    }

    public EventNotificationList(int noOfEvents, List<ExtensionObjectDefinition> events) {
        this.noOfEvents = noOfEvents;
        this.events = events;
    }

    public int getNoOfEvents() {
        return this.noOfEvents;
    }

    public List<ExtensionObjectDefinition> getEvents() {
        return this.events;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EventNotificationList", new WithWriterArgs[0]);
        int notificationLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField("notificationLength", notificationLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfEvents", this.noOfEvents, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("events", this.events, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("EventNotificationList", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EventNotificationList _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.events != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.events) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.events.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("EventNotificationList", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int notificationLength = FieldReaderFactory.readImplicitField("notificationLength", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        int noOfEvents = FieldReaderFactory.readSimpleField("noOfEvents", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> events = FieldReaderFactory.readCountArrayField("events", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "919"), readBuffer), noOfEvents, new WithReaderArgs[0]);
        readBuffer.closeContext("EventNotificationList", new WithReaderArgs[0]);
        return new EventNotificationListBuilderImpl(noOfEvents, events);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventNotificationList)) {
            return false;
        }
        EventNotificationList that = (EventNotificationList)o;
        return this.getNoOfEvents() == that.getNoOfEvents() && this.getEvents() == that.getEvents() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfEvents(), this.getEvents());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EventNotificationListBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfEvents;
        private final List<ExtensionObjectDefinition> events;

        public EventNotificationListBuilderImpl(int noOfEvents, List<ExtensionObjectDefinition> events) {
            this.noOfEvents = noOfEvents;
            this.events = events;
        }

        @Override
        public EventNotificationList build() {
            EventNotificationList eventNotificationList = new EventNotificationList(this.noOfEvents, this.events);
            return eventNotificationList;
        }
    }
}

