/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ExpandedNodeId
implements Message {
    protected final boolean namespaceURISpecified;
    protected final boolean serverIndexSpecified;
    protected final NodeIdTypeDefinition nodeId;
    protected final PascalString namespaceURI;
    protected final Long serverIndex;

    public ExpandedNodeId(boolean namespaceURISpecified, boolean serverIndexSpecified, NodeIdTypeDefinition nodeId, PascalString namespaceURI, Long serverIndex) {
        this.namespaceURISpecified = namespaceURISpecified;
        this.serverIndexSpecified = serverIndexSpecified;
        this.nodeId = nodeId;
        this.namespaceURI = namespaceURI;
        this.serverIndex = serverIndex;
    }

    public boolean getNamespaceURISpecified() {
        return this.namespaceURISpecified;
    }

    public boolean getServerIndexSpecified() {
        return this.serverIndexSpecified;
    }

    public NodeIdTypeDefinition getNodeId() {
        return this.nodeId;
    }

    public PascalString getNamespaceURI() {
        return this.namespaceURI;
    }

    public Long getServerIndex() {
        return this.serverIndex;
    }

    public String getIdentifier() {
        return String.valueOf(this.getNodeId().getIdentifier());
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ExpandedNodeId", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("namespaceURISpecified", this.namespaceURISpecified, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serverIndexSpecified", this.serverIndexSpecified, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("nodeId", this.nodeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", identifier, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("namespaceURI", this.namespaceURI, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("serverIndex", this.serverIndex, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("ExpandedNodeId", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        ExpandedNodeId _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += this.nodeId.getLengthInBits();
        if (this.namespaceURI != null) {
            lengthInBits += this.namespaceURI.getLengthInBits();
        }
        if (this.serverIndex != null) {
            lengthInBits += 32;
        }
        return lengthInBits;
    }

    public static ExpandedNodeId staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ExpandedNodeId.staticParse(readBuffer);
    }

    public static ExpandedNodeId staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ExpandedNodeId", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        boolean namespaceURISpecified = FieldReaderFactory.readSimpleField("namespaceURISpecified", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        boolean serverIndexSpecified = FieldReaderFactory.readSimpleField("serverIndexSpecified", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        NodeIdTypeDefinition nodeId = FieldReaderFactory.readSimpleField("nodeId", new DataReaderComplexDefault<NodeIdTypeDefinition>(() -> NodeIdTypeDefinition.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        String identifier = FieldReaderFactory.readVirtualField("identifier", String.class, nodeId.getIdentifier(), new WithReaderArgs[0]);
        PascalString namespaceURI = FieldReaderFactory.readOptionalField("namespaceURI", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), namespaceURISpecified, new WithReaderArgs[0]);
        Long serverIndex = FieldReaderFactory.readOptionalField("serverIndex", DataReaderFactory.readUnsignedLong(readBuffer, 32), serverIndexSpecified, new WithReaderArgs[0]);
        readBuffer.closeContext("ExpandedNodeId", new WithReaderArgs[0]);
        ExpandedNodeId _expandedNodeId = new ExpandedNodeId(namespaceURISpecified, serverIndexSpecified, nodeId, namespaceURI, serverIndex);
        return _expandedNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpandedNodeId)) {
            return false;
        }
        ExpandedNodeId that = (ExpandedNodeId)o;
        return this.getNamespaceURISpecified() == that.getNamespaceURISpecified() && this.getServerIndexSpecified() == that.getServerIndexSpecified() && this.getNodeId() == that.getNodeId() && this.getNamespaceURI() == that.getNamespaceURI() && this.getServerIndex() == that.getServerIndex();
    }

    public int hashCode() {
        return Objects.hash(this.getNamespaceURISpecified(), this.getServerIndexSpecified(), this.getNodeId(), this.getNamespaceURI(), this.getServerIndex());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

