/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class HistoryReadRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final ExtensionObject historyReadDetails;
    protected final TimestampsToReturn timestampsToReturn;
    protected final boolean releaseContinuationPoints;
    protected final int noOfNodesToRead;
    protected final List<ExtensionObjectDefinition> nodesToRead;

    @Override
    public String getIdentifier() {
        return "664";
    }

    public HistoryReadRequest(ExtensionObjectDefinition requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, int noOfNodesToRead, List<ExtensionObjectDefinition> nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.noOfNodesToRead = noOfNodesToRead;
        this.nodesToRead = nodesToRead;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public int getNoOfNodesToRead() {
        return this.noOfNodesToRead;
    }

    public List<ExtensionObjectDefinition> getNodesToRead() {
        return this.nodesToRead;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("historyReadDetails", this.historyReadDetails, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("timestampsToReturn", "TimestampsToReturn", this.timestampsToReturn, new DataWriterEnumDefault<TimestampsToReturn, Long>(TimestampsToReturn::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("releaseContinuationPoints", this.releaseContinuationPoints, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNodesToRead", this.noOfNodesToRead, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("nodesToRead", this.nodesToRead, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryReadRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.historyReadDetails.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.nodesToRead != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.nodesToRead) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToRead.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        ExtensionObject historyReadDetails = FieldReaderFactory.readSimpleField("historyReadDetails", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField("timestampsToReturn", "TimestampsToReturn", new DataReaderEnumDefault<TimestampsToReturn, Long>(TimestampsToReturn::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
        boolean releaseContinuationPoints = FieldReaderFactory.readSimpleField("releaseContinuationPoints", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        int noOfNodesToRead = FieldReaderFactory.readSimpleField("noOfNodesToRead", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> nodesToRead = FieldReaderFactory.readCountArrayField("nodesToRead", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "637"), readBuffer), noOfNodesToRead, new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryReadRequest", new WithReaderArgs[0]);
        return new HistoryReadRequestBuilderImpl(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, noOfNodesToRead, nodesToRead);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryReadRequest)) {
            return false;
        }
        HistoryReadRequest that = (HistoryReadRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getHistoryReadDetails() == that.getHistoryReadDetails() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getReleaseContinuationPoints() == that.getReleaseContinuationPoints() && this.getNoOfNodesToRead() == that.getNoOfNodesToRead() && this.getNodesToRead() == that.getNodesToRead() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNoOfNodesToRead(), this.getNodesToRead()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryReadRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final ExtensionObject historyReadDetails;
        private final TimestampsToReturn timestampsToReturn;
        private final boolean releaseContinuationPoints;
        private final int noOfNodesToRead;
        private final List<ExtensionObjectDefinition> nodesToRead;

        public HistoryReadRequestBuilderImpl(ExtensionObjectDefinition requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, int noOfNodesToRead, List<ExtensionObjectDefinition> nodesToRead) {
            this.requestHeader = requestHeader;
            this.historyReadDetails = historyReadDetails;
            this.timestampsToReturn = timestampsToReturn;
            this.releaseContinuationPoints = releaseContinuationPoints;
            this.noOfNodesToRead = noOfNodesToRead;
            this.nodesToRead = nodesToRead;
        }

        @Override
        public HistoryReadRequest build() {
            HistoryReadRequest historyReadRequest = new HistoryReadRequest(this.requestHeader, this.historyReadDetails, this.timestampsToReturn, this.releaseContinuationPoints, this.noOfNodesToRead, this.nodesToRead);
            return historyReadRequest;
        }
    }
}

