/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class HistoryReadValueId
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final PascalString indexRange;
    protected final QualifiedName dataEncoding;
    protected final PascalByteString continuationPoint;

    @Override
    public String getIdentifier() {
        return "637";
    }

    public HistoryReadValueId(NodeId nodeId, PascalString indexRange, QualifiedName dataEncoding, PascalByteString continuationPoint) {
        this.nodeId = nodeId;
        this.indexRange = indexRange;
        this.dataEncoding = dataEncoding;
        this.continuationPoint = continuationPoint;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public PascalString getIndexRange() {
        return this.indexRange;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public PascalByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryReadValueId", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("nodeId", this.nodeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("indexRange", this.indexRange, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("dataEncoding", this.dataEncoding, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("continuationPoint", this.continuationPoint, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryReadValueId", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryReadValueId _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += this.indexRange.getLengthInBits();
        lengthInBits += this.dataEncoding.getLengthInBits();
        return lengthInBits += this.continuationPoint.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryReadValueId", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = FieldReaderFactory.readSimpleField("nodeId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString indexRange = FieldReaderFactory.readSimpleField("indexRange", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        QualifiedName dataEncoding = FieldReaderFactory.readSimpleField("dataEncoding", new DataReaderComplexDefault<QualifiedName>(() -> QualifiedName.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString continuationPoint = FieldReaderFactory.readSimpleField("continuationPoint", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryReadValueId", new WithReaderArgs[0]);
        return new HistoryReadValueIdBuilderImpl(nodeId, indexRange, dataEncoding, continuationPoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryReadValueId)) {
            return false;
        }
        HistoryReadValueId that = (HistoryReadValueId)o;
        return this.getNodeId() == that.getNodeId() && this.getIndexRange() == that.getIndexRange() && this.getDataEncoding() == that.getDataEncoding() && this.getContinuationPoint() == that.getContinuationPoint() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getIndexRange(), this.getDataEncoding(), this.getContinuationPoint());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryReadValueIdBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final PascalString indexRange;
        private final QualifiedName dataEncoding;
        private final PascalByteString continuationPoint;

        public HistoryReadValueIdBuilderImpl(NodeId nodeId, PascalString indexRange, QualifiedName dataEncoding, PascalByteString continuationPoint) {
            this.nodeId = nodeId;
            this.indexRange = indexRange;
            this.dataEncoding = dataEncoding;
            this.continuationPoint = continuationPoint;
        }

        @Override
        public HistoryReadValueId build() {
            HistoryReadValueId historyReadValueId = new HistoryReadValueId(this.nodeId, this.indexRange, this.dataEncoding, this.continuationPoint);
            return historyReadValueId;
        }
    }
}

