/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class MonitoringParameters
extends ExtensionObjectDefinition
implements Message {
    protected final long clientHandle;
    protected final double samplingInterval;
    protected final ExtensionObject filter;
    protected final long queueSize;
    protected final boolean discardOldest;

    @Override
    public String getIdentifier() {
        return "742";
    }

    public MonitoringParameters(long clientHandle, double samplingInterval, ExtensionObject filter, long queueSize, boolean discardOldest) {
        this.clientHandle = clientHandle;
        this.samplingInterval = samplingInterval;
        this.filter = filter;
        this.queueSize = queueSize;
        this.discardOldest = discardOldest;
    }

    public long getClientHandle() {
        return this.clientHandle;
    }

    public double getSamplingInterval() {
        return this.samplingInterval;
    }

    public ExtensionObject getFilter() {
        return this.filter;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public boolean getDiscardOldest() {
        return this.discardOldest;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("MonitoringParameters", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientHandle", this.clientHandle, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("samplingInterval", this.samplingInterval, DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("filter", this.filter, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("queueSize", this.queueSize, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("discardOldest", this.discardOldest, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("MonitoringParameters", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        MonitoringParameters _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += this.filter.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("MonitoringParameters", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long clientHandle = FieldReaderFactory.readSimpleField("clientHandle", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        double samplingInterval = FieldReaderFactory.readSimpleField("samplingInterval", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
        ExtensionObject filter = FieldReaderFactory.readSimpleField("filter", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), new WithReaderArgs[0]);
        long queueSize = FieldReaderFactory.readSimpleField("queueSize", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
        boolean discardOldest = FieldReaderFactory.readSimpleField("discardOldest", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("MonitoringParameters", new WithReaderArgs[0]);
        return new MonitoringParametersBuilderImpl(clientHandle, samplingInterval, filter, queueSize, discardOldest);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitoringParameters)) {
            return false;
        }
        MonitoringParameters that = (MonitoringParameters)o;
        return this.getClientHandle() == that.getClientHandle() && this.getSamplingInterval() == that.getSamplingInterval() && this.getFilter() == that.getFilter() && this.getQueueSize() == that.getQueueSize() && this.getDiscardOldest() == that.getDiscardOldest() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClientHandle(), this.getSamplingInterval(), this.getFilter(), this.getQueueSize(), this.getDiscardOldest());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class MonitoringParametersBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long clientHandle;
        private final double samplingInterval;
        private final ExtensionObject filter;
        private final long queueSize;
        private final boolean discardOldest;

        public MonitoringParametersBuilderImpl(long clientHandle, double samplingInterval, ExtensionObject filter, long queueSize, boolean discardOldest) {
            this.clientHandle = clientHandle;
            this.samplingInterval = samplingInterval;
            this.filter = filter;
            this.queueSize = queueSize;
            this.discardOldest = discardOldest;
        }

        @Override
        public MonitoringParameters build() {
            MonitoringParameters monitoringParameters = new MonitoringParameters(this.clientHandle, this.samplingInterval, this.filter, this.queueSize, this.discardOldest);
            return monitoringParameters;
        }
    }
}

