/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class NetworkGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString serverUri;
    protected final int noOfNetworkPaths;
    protected final List<ExtensionObjectDefinition> networkPaths;

    @Override
    public String getIdentifier() {
        return "11946";
    }

    public NetworkGroupDataType(PascalString serverUri, int noOfNetworkPaths, List<ExtensionObjectDefinition> networkPaths) {
        this.serverUri = serverUri;
        this.noOfNetworkPaths = noOfNetworkPaths;
        this.networkPaths = networkPaths;
    }

    public PascalString getServerUri() {
        return this.serverUri;
    }

    public int getNoOfNetworkPaths() {
        return this.noOfNetworkPaths;
    }

    public List<ExtensionObjectDefinition> getNetworkPaths() {
        return this.networkPaths;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NetworkGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serverUri", this.serverUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNetworkPaths", this.noOfNetworkPaths, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("networkPaths", this.networkPaths, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("NetworkGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NetworkGroupDataType _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.serverUri.getLengthInBits();
        lengthInBits += 32;
        if (this.networkPaths != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.networkPaths) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.networkPaths.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("NetworkGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString serverUri = FieldReaderFactory.readSimpleField("serverUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfNetworkPaths = FieldReaderFactory.readSimpleField("noOfNetworkPaths", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> networkPaths = FieldReaderFactory.readCountArrayField("networkPaths", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "11945"), readBuffer), noOfNetworkPaths, new WithReaderArgs[0]);
        readBuffer.closeContext("NetworkGroupDataType", new WithReaderArgs[0]);
        return new NetworkGroupDataTypeBuilderImpl(serverUri, noOfNetworkPaths, networkPaths);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkGroupDataType)) {
            return false;
        }
        NetworkGroupDataType that = (NetworkGroupDataType)o;
        return this.getServerUri() == that.getServerUri() && this.getNoOfNetworkPaths() == that.getNoOfNetworkPaths() && this.getNetworkPaths() == that.getNetworkPaths() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServerUri(), this.getNoOfNetworkPaths(), this.getNetworkPaths());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NetworkGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString serverUri;
        private final int noOfNetworkPaths;
        private final List<ExtensionObjectDefinition> networkPaths;

        public NetworkGroupDataTypeBuilderImpl(PascalString serverUri, int noOfNetworkPaths, List<ExtensionObjectDefinition> networkPaths) {
            this.serverUri = serverUri;
            this.noOfNetworkPaths = noOfNetworkPaths;
            this.networkPaths = networkPaths;
        }

        @Override
        public NetworkGroupDataType build() {
            NetworkGroupDataType networkGroupDataType = new NetworkGroupDataType(this.serverUri, this.noOfNetworkPaths, this.networkPaths);
            return networkGroupDataType;
        }
    }
}

