/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdType;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class NodeIdString
extends NodeIdTypeDefinition
implements Message {
    protected final int namespaceIndex;
    protected final PascalString id;

    @Override
    public NodeIdType getNodeType() {
        return NodeIdType.nodeIdTypeString;
    }

    public NodeIdString(int namespaceIndex, PascalString id) {
        this.namespaceIndex = namespaceIndex;
        this.id = id;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public PascalString getId() {
        return this.id;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.getId().getStringValue());
    }

    @Override
    protected void serializeNodeIdTypeDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NodeIdString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("namespaceIndex", this.namespaceIndex, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("id", this.id, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", identifier, new WithWriterArgs[0]);
        writeBuffer.popContext("NodeIdString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeIdString _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        return lengthInBits += this.id.getLengthInBits();
    }

    public static NodeIdTypeDefinition.NodeIdTypeDefinitionBuilder staticParseNodeIdTypeDefinitionBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("NodeIdString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int namespaceIndex = FieldReaderFactory.readSimpleField("namespaceIndex", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        PascalString id = FieldReaderFactory.readSimpleField("id", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        String identifier = FieldReaderFactory.readVirtualField("identifier", String.class, id.getStringValue(), new WithReaderArgs[0]);
        readBuffer.closeContext("NodeIdString", new WithReaderArgs[0]);
        return new NodeIdStringBuilderImpl(namespaceIndex, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeIdString)) {
            return false;
        }
        NodeIdString that = (NodeIdString)o;
        return this.getNamespaceIndex() == that.getNamespaceIndex() && this.getId() == that.getId() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaceIndex(), this.getId());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeIdStringBuilderImpl
    implements NodeIdTypeDefinition.NodeIdTypeDefinitionBuilder {
        private final int namespaceIndex;
        private final PascalString id;

        public NodeIdStringBuilderImpl(int namespaceIndex, PascalString id) {
            this.namespaceIndex = namespaceIndex;
            this.id = id;
        }

        @Override
        public NodeIdString build() {
            NodeIdString nodeIdString = new NodeIdString(this.namespaceIndex, this.id);
            return nodeIdString;
        }
    }
}

