/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class NotificationMessage
extends ExtensionObjectDefinition
implements Message {
    protected final long sequenceNumber;
    protected final long publishTime;
    protected final int noOfNotificationData;
    protected final List<ExtensionObject> notificationData;

    @Override
    public String getIdentifier() {
        return "805";
    }

    public NotificationMessage(long sequenceNumber, long publishTime, int noOfNotificationData, List<ExtensionObject> notificationData) {
        this.sequenceNumber = sequenceNumber;
        this.publishTime = publishTime;
        this.noOfNotificationData = noOfNotificationData;
        this.notificationData = notificationData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getPublishTime() {
        return this.publishTime;
    }

    public int getNoOfNotificationData() {
        return this.noOfNotificationData;
    }

    public List<ExtensionObject> getNotificationData() {
        return this.notificationData;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NotificationMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sequenceNumber", this.sequenceNumber, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("publishTime", this.publishTime, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNotificationData", this.noOfNotificationData, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("notificationData", this.notificationData, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("NotificationMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NotificationMessage _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.notificationData != null) {
            int i = 0;
            for (ExtensionObject element : this.notificationData) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.notificationData.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("NotificationMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long sequenceNumber = FieldReaderFactory.readSimpleField("sequenceNumber", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long publishTime = FieldReaderFactory.readSimpleField("publishTime", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        int noOfNotificationData = FieldReaderFactory.readSimpleField("noOfNotificationData", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObject> notificationData = FieldReaderFactory.readCountArrayField("notificationData", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), noOfNotificationData, new WithReaderArgs[0]);
        readBuffer.closeContext("NotificationMessage", new WithReaderArgs[0]);
        return new NotificationMessageBuilderImpl(sequenceNumber, publishTime, noOfNotificationData, notificationData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationMessage)) {
            return false;
        }
        NotificationMessage that = (NotificationMessage)o;
        return this.getSequenceNumber() == that.getSequenceNumber() && this.getPublishTime() == that.getPublishTime() && this.getNoOfNotificationData() == that.getNoOfNotificationData() && this.getNotificationData() == that.getNotificationData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSequenceNumber(), this.getPublishTime(), this.getNoOfNotificationData(), this.getNotificationData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NotificationMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long sequenceNumber;
        private final long publishTime;
        private final int noOfNotificationData;
        private final List<ExtensionObject> notificationData;

        public NotificationMessageBuilderImpl(long sequenceNumber, long publishTime, int noOfNotificationData, List<ExtensionObject> notificationData) {
            this.sequenceNumber = sequenceNumber;
            this.publishTime = publishTime;
            this.noOfNotificationData = noOfNotificationData;
            this.notificationData = notificationData;
        }

        @Override
        public NotificationMessage build() {
            NotificationMessage notificationMessage = new NotificationMessage(this.sequenceNumber, this.publishTime, this.noOfNotificationData, this.notificationData);
            return notificationMessage;
        }
    }
}

