/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.SecurityHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpcuaCloseRequest
extends MessagePDU
implements Message {
    protected final SecurityHeader securityHeader;
    protected final Payload message;

    @Override
    public String getMessageType() {
        return "CLO";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaCloseRequest(ChunkType chunk, SecurityHeader securityHeader, Payload message) {
        super(chunk);
        this.securityHeader = securityHeader;
        this.message = message;
    }

    public SecurityHeader getSecurityHeader() {
        return this.securityHeader;
    }

    public Payload getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaCloseRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("securityHeader", this.securityHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("message", this.message, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaCloseRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaCloseRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.securityHeader.getLengthInBits();
        return lengthInBits += this.message.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaCloseRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        SecurityHeader securityHeader = FieldReaderFactory.readSimpleField("securityHeader", new DataReaderComplexDefault<SecurityHeader>(() -> SecurityHeader.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        Payload message = FieldReaderFactory.readSimpleField("message", new DataReaderComplexDefault<Payload>(() -> Payload.staticParse(readBuffer, false, 0L), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaCloseRequest", new WithReaderArgs[0]);
        return new OpcuaCloseRequestBuilderImpl(securityHeader, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaCloseRequest)) {
            return false;
        }
        OpcuaCloseRequest that = (OpcuaCloseRequest)o;
        return this.getSecurityHeader() == that.getSecurityHeader() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSecurityHeader(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaCloseRequestBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final SecurityHeader securityHeader;
        private final Payload message;

        public OpcuaCloseRequestBuilderImpl(SecurityHeader securityHeader, Payload message) {
            this.securityHeader = securityHeader;
            this.message = message;
        }

        @Override
        public OpcuaCloseRequest build(ChunkType chunk) {
            OpcuaCloseRequest opcuaCloseRequest = new OpcuaCloseRequest(chunk, this.securityHeader, this.message);
            return opcuaCloseRequest;
        }
    }
}

