/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpcuaMessageError
extends MessagePDU
implements Message {
    protected final OpcuaStatusCode error;
    protected final PascalString reason;

    @Override
    public String getMessageType() {
        return "ERR";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaMessageError(ChunkType chunk, OpcuaStatusCode error, PascalString reason) {
        super(chunk);
        this.error = error;
        this.reason = reason;
    }

    public OpcuaStatusCode getError() {
        return this.error;
    }

    public PascalString getReason() {
        return this.reason;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaMessageError", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("error", "OpcuaStatusCode", this.error, new DataWriterEnumDefault<OpcuaStatusCode, Long>(OpcuaStatusCode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("reason", this.reason, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaMessageError", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaMessageError _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += this.reason.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaMessageError", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        OpcuaStatusCode error = (OpcuaStatusCode)((Object)FieldReaderFactory.readEnumField("error", "OpcuaStatusCode", new DataReaderEnumDefault<OpcuaStatusCode, Long>(OpcuaStatusCode::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        PascalString reason = FieldReaderFactory.readSimpleField("reason", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaMessageError", new WithReaderArgs[0]);
        return new OpcuaMessageErrorBuilderImpl(error, reason);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaMessageError)) {
            return false;
        }
        OpcuaMessageError that = (OpcuaMessageError)o;
        return this.getError() == that.getError() && this.getReason() == that.getReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getError(), this.getReason()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaMessageErrorBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final OpcuaStatusCode error;
        private final PascalString reason;

        public OpcuaMessageErrorBuilderImpl(OpcuaStatusCode error, PascalString reason) {
            this.error = error;
            this.reason = reason;
        }

        @Override
        public OpcuaMessageError build(ChunkType chunk) {
            OpcuaMessageError opcuaMessageError = new OpcuaMessageError(chunk, this.error, this.reason);
            return opcuaMessageError;
        }
    }
}

