/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.SecurityHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpcuaMessageResponse
extends MessagePDU
implements Message {
    protected final SecurityHeader securityHeader;
    protected final Payload message;

    @Override
    public String getMessageType() {
        return "MSG";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaMessageResponse(ChunkType chunk, SecurityHeader securityHeader, Payload message) {
        super(chunk);
        this.securityHeader = securityHeader;
        this.message = message;
    }

    public SecurityHeader getSecurityHeader() {
        return this.securityHeader;
    }

    public Payload getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaMessageResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("securityHeader", this.securityHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("message", this.message, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaMessageResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaMessageResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.securityHeader.getLengthInBits();
        return lengthInBits += this.message.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Long totalLength, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaMessageResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        SecurityHeader securityHeader = FieldReaderFactory.readSimpleField("securityHeader", new DataReaderComplexDefault<SecurityHeader>(() -> SecurityHeader.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        Payload message = FieldReaderFactory.readSimpleField("message", new DataReaderComplexDefault<Payload>(() -> Payload.staticParse(readBuffer, false, totalLength - (long)securityHeader.getLengthInBytes() - 16L), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaMessageResponse", new WithReaderArgs[0]);
        return new OpcuaMessageResponseBuilderImpl(securityHeader, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaMessageResponse)) {
            return false;
        }
        OpcuaMessageResponse that = (OpcuaMessageResponse)o;
        return this.getSecurityHeader() == that.getSecurityHeader() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSecurityHeader(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaMessageResponseBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final SecurityHeader securityHeader;
        private final Payload message;

        public OpcuaMessageResponseBuilderImpl(SecurityHeader securityHeader, Payload message) {
            this.securityHeader = securityHeader;
            this.message = message;
        }

        @Override
        public OpcuaMessageResponse build(ChunkType chunk) {
            OpcuaMessageResponse opcuaMessageResponse = new OpcuaMessageResponse(chunk, this.securityHeader, this.message);
            return opcuaMessageResponse;
        }
    }
}

