/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpcuaProtocolLimits
implements Message {
    protected final long receiveBufferSize;
    protected final long sendBufferSize;
    protected final long maxMessageSize;
    protected final long maxChunkCount;

    public OpcuaProtocolLimits(long receiveBufferSize, long sendBufferSize, long maxMessageSize, long maxChunkCount) {
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
    }

    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public long getMaxChunkCount() {
        return this.maxChunkCount;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaProtocolLimits", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("receiveBufferSize", this.receiveBufferSize, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sendBufferSize", this.sendBufferSize, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("maxMessageSize", this.maxMessageSize, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("maxChunkCount", this.maxChunkCount, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaProtocolLimits", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        OpcuaProtocolLimits _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static OpcuaProtocolLimits staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return OpcuaProtocolLimits.staticParse(readBuffer);
    }

    public static OpcuaProtocolLimits staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("OpcuaProtocolLimits", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long receiveBufferSize = FieldReaderFactory.readSimpleField("receiveBufferSize", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long sendBufferSize = FieldReaderFactory.readSimpleField("sendBufferSize", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long maxMessageSize = FieldReaderFactory.readSimpleField("maxMessageSize", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long maxChunkCount = FieldReaderFactory.readSimpleField("maxChunkCount", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaProtocolLimits", new WithReaderArgs[0]);
        OpcuaProtocolLimits _opcuaProtocolLimits = new OpcuaProtocolLimits(receiveBufferSize, sendBufferSize, maxMessageSize, maxChunkCount);
        return _opcuaProtocolLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaProtocolLimits)) {
            return false;
        }
        OpcuaProtocolLimits that = (OpcuaProtocolLimits)o;
        return this.getReceiveBufferSize() == that.getReceiveBufferSize() && this.getSendBufferSize() == that.getSendBufferSize() && this.getMaxMessageSize() == that.getMaxMessageSize() && this.getMaxChunkCount() == that.getMaxChunkCount();
    }

    public int hashCode() {
        return Objects.hash(this.getReceiveBufferSize(), this.getSendBufferSize(), this.getMaxMessageSize(), this.getMaxChunkCount());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

