/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.OpenChannelMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpenChannelMessageResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class OpenChannelMessage
implements Message {
    public abstract Boolean getResponse();

    protected abstract void serializeOpenChannelMessageChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpenChannelMessage", new WithWriterArgs[0]);
        this.serializeOpenChannelMessageChild(writeBuffer);
        writeBuffer.popContext("OpenChannelMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        OpenChannelMessage _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static OpenChannelMessage staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return OpenChannelMessage.staticParse(readBuffer, response);
    }

    public static OpenChannelMessage staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpenChannelMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        OpenChannelMessageBuilder builder = null;
        if (EvaluationHelper.equals(response, false)) {
            builder = OpenChannelMessageRequest.staticParseOpenChannelMessageBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(response, true)) {
            builder = OpenChannelMessageResponse.staticParseOpenChannelMessageBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [response=" + response + "]");
        }
        readBuffer.closeContext("OpenChannelMessage", new WithReaderArgs[0]);
        OpenChannelMessage _openChannelMessage = builder.build();
        return _openChannelMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenChannelMessage)) {
            return false;
        }
        OpenChannelMessage that = (OpenChannelMessage)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface OpenChannelMessageBuilder {
        public OpenChannelMessage build();
    }
}

