/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.SecurityTokenRequestType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpenSecureChannelRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final long clientProtocolVersion;
    protected final SecurityTokenRequestType requestType;
    protected final MessageSecurityMode securityMode;
    protected final PascalByteString clientNonce;
    protected final long requestedLifetime;

    @Override
    public String getIdentifier() {
        return "446";
    }

    public OpenSecureChannelRequest(ExtensionObjectDefinition requestHeader, long clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, PascalByteString clientNonce, long requestedLifetime) {
        this.requestHeader = requestHeader;
        this.clientProtocolVersion = clientProtocolVersion;
        this.requestType = requestType;
        this.securityMode = securityMode;
        this.clientNonce = clientNonce;
        this.requestedLifetime = requestedLifetime;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public long getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public SecurityTokenRequestType getRequestType() {
        return this.requestType;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalByteString getClientNonce() {
        return this.clientNonce;
    }

    public long getRequestedLifetime() {
        return this.requestedLifetime;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpenSecureChannelRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientProtocolVersion", this.clientProtocolVersion, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("requestType", "SecurityTokenRequestType", this.requestType, new DataWriterEnumDefault<SecurityTokenRequestType, Long>(SecurityTokenRequestType::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("securityMode", "MessageSecurityMode", this.securityMode, new DataWriterEnumDefault<MessageSecurityMode, Long>(MessageSecurityMode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("clientNonce", this.clientNonce, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestedLifetime", this.requestedLifetime, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("OpenSecureChannelRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpenSecureChannelRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.clientNonce.getLengthInBits();
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("OpenSecureChannelRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        long clientProtocolVersion = FieldReaderFactory.readSimpleField("clientProtocolVersion", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        SecurityTokenRequestType requestType = (SecurityTokenRequestType)((Object)FieldReaderFactory.readEnumField("requestType", "SecurityTokenRequestType", new DataReaderEnumDefault<SecurityTokenRequestType, Long>(SecurityTokenRequestType::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField("securityMode", "MessageSecurityMode", new DataReaderEnumDefault<MessageSecurityMode, Long>(MessageSecurityMode::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        PascalByteString clientNonce = FieldReaderFactory.readSimpleField("clientNonce", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long requestedLifetime = FieldReaderFactory.readSimpleField("requestedLifetime", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("OpenSecureChannelRequest", new WithReaderArgs[0]);
        return new OpenSecureChannelRequestBuilderImpl(requestHeader, clientProtocolVersion, requestType, securityMode, clientNonce, requestedLifetime);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSecureChannelRequest)) {
            return false;
        }
        OpenSecureChannelRequest that = (OpenSecureChannelRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getClientProtocolVersion() == that.getClientProtocolVersion() && this.getRequestType() == that.getRequestType() && this.getSecurityMode() == that.getSecurityMode() && this.getClientNonce() == that.getClientNonce() && this.getRequestedLifetime() == that.getRequestedLifetime() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getClientProtocolVersion(), this.getRequestType(), this.getSecurityMode(), this.getClientNonce(), this.getRequestedLifetime()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpenSecureChannelRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final long clientProtocolVersion;
        private final SecurityTokenRequestType requestType;
        private final MessageSecurityMode securityMode;
        private final PascalByteString clientNonce;
        private final long requestedLifetime;

        public OpenSecureChannelRequestBuilderImpl(ExtensionObjectDefinition requestHeader, long clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, PascalByteString clientNonce, long requestedLifetime) {
            this.requestHeader = requestHeader;
            this.clientProtocolVersion = clientProtocolVersion;
            this.requestType = requestType;
            this.securityMode = securityMode;
            this.clientNonce = clientNonce;
            this.requestedLifetime = requestedLifetime;
        }

        @Override
        public OpenSecureChannelRequest build() {
            OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest(this.requestHeader, this.clientProtocolVersion, this.requestType, this.securityMode, this.clientNonce, this.requestedLifetime);
            return openSecureChannelRequest;
        }
    }
}

