/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ParsingResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final int noOfDataStatusCodes;
    protected final List<StatusCode> dataStatusCodes;
    protected final int noOfDataDiagnosticInfos;
    protected final List<DiagnosticInfo> dataDiagnosticInfos;

    @Override
    public String getIdentifier() {
        return "612";
    }

    public ParsingResult(StatusCode statusCode, int noOfDataStatusCodes, List<StatusCode> dataStatusCodes, int noOfDataDiagnosticInfos, List<DiagnosticInfo> dataDiagnosticInfos) {
        this.statusCode = statusCode;
        this.noOfDataStatusCodes = noOfDataStatusCodes;
        this.dataStatusCodes = dataStatusCodes;
        this.noOfDataDiagnosticInfos = noOfDataDiagnosticInfos;
        this.dataDiagnosticInfos = dataDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getNoOfDataStatusCodes() {
        return this.noOfDataStatusCodes;
    }

    public List<StatusCode> getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    public int getNoOfDataDiagnosticInfos() {
        return this.noOfDataDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ParsingResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("statusCode", this.statusCode, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDataStatusCodes", this.noOfDataStatusCodes, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("dataStatusCodes", this.dataStatusCodes, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDataDiagnosticInfos", this.noOfDataDiagnosticInfos, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("dataDiagnosticInfos", this.dataDiagnosticInfos, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("ParsingResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ParsingResult _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.dataStatusCodes != null) {
            i = 0;
            for (StatusCode statusCode : this.dataStatusCodes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataStatusCodes.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.dataDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.dataDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ParsingResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = FieldReaderFactory.readSimpleField("statusCode", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfDataStatusCodes = FieldReaderFactory.readSimpleField("noOfDataStatusCodes", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<StatusCode> dataStatusCodes = FieldReaderFactory.readCountArrayField("dataStatusCodes", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), noOfDataStatusCodes, new WithReaderArgs[0]);
        int noOfDataDiagnosticInfos = FieldReaderFactory.readSimpleField("noOfDataDiagnosticInfos", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DiagnosticInfo> dataDiagnosticInfos = FieldReaderFactory.readCountArrayField("dataDiagnosticInfos", new DataReaderComplexDefault<DiagnosticInfo>(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), noOfDataDiagnosticInfos, new WithReaderArgs[0]);
        readBuffer.closeContext("ParsingResult", new WithReaderArgs[0]);
        return new ParsingResultBuilderImpl(statusCode, noOfDataStatusCodes, dataStatusCodes, noOfDataDiagnosticInfos, dataDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsingResult)) {
            return false;
        }
        ParsingResult that = (ParsingResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getNoOfDataStatusCodes() == that.getNoOfDataStatusCodes() && this.getDataStatusCodes() == that.getDataStatusCodes() && this.getNoOfDataDiagnosticInfos() == that.getNoOfDataDiagnosticInfos() && this.getDataDiagnosticInfos() == that.getDataDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getNoOfDataStatusCodes(), this.getDataStatusCodes(), this.getNoOfDataDiagnosticInfos(), this.getDataDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ParsingResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final int noOfDataStatusCodes;
        private final List<StatusCode> dataStatusCodes;
        private final int noOfDataDiagnosticInfos;
        private final List<DiagnosticInfo> dataDiagnosticInfos;

        public ParsingResultBuilderImpl(StatusCode statusCode, int noOfDataStatusCodes, List<StatusCode> dataStatusCodes, int noOfDataDiagnosticInfos, List<DiagnosticInfo> dataDiagnosticInfos) {
            this.statusCode = statusCode;
            this.noOfDataStatusCodes = noOfDataStatusCodes;
            this.dataStatusCodes = dataStatusCodes;
            this.noOfDataDiagnosticInfos = noOfDataDiagnosticInfos;
            this.dataDiagnosticInfos = dataDiagnosticInfos;
        }

        @Override
        public ParsingResult build() {
            ParsingResult parsingResult = new ParsingResult(this.statusCode, this.noOfDataStatusCodes, this.dataStatusCodes, this.noOfDataDiagnosticInfos, this.dataDiagnosticInfos);
            return parsingResult;
        }
    }
}

