/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class PascalByteString
implements Message {
    protected final int stringLength;
    protected final byte[] stringValue;

    public PascalByteString(int stringLength, byte[] stringValue) {
        this.stringLength = stringLength;
        this.stringValue = stringValue;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PascalByteString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("stringLength", this.stringLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("stringValue", this.stringValue, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("PascalByteString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        PascalByteString _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.stringValue != null) {
            lengthInBits += 8 * this.stringValue.length;
        }
        return lengthInBits;
    }

    public static PascalByteString staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return PascalByteString.staticParse(readBuffer);
    }

    public static PascalByteString staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("PascalByteString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int stringLength = FieldReaderFactory.readSimpleField("stringLength", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        byte[] stringValue = readBuffer.readByteArray("stringValue", Math.toIntExact(stringLength == -1 ? 0 : stringLength), new WithReaderArgs[0]);
        readBuffer.closeContext("PascalByteString", new WithReaderArgs[0]);
        PascalByteString _pascalByteString = new PascalByteString(stringLength, stringValue);
        return _pascalByteString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PascalByteString)) {
            return false;
        }
        PascalByteString that = (PascalByteString)o;
        return this.getStringLength() == that.getStringLength() && this.getStringValue() == that.getStringValue();
    }

    public int hashCode() {
        return Objects.hash(this.getStringLength(), this.getStringValue());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

