/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class PascalString
implements Message {
    protected final String stringValue;

    public PascalString(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int getStringLength() {
        return StaticHelper.pascalLengthToUtf8Length(StaticHelper.utf8LengthToPascalLength(this.getStringValue()));
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PascalString", new WithWriterArgs[0]);
        int sLength = StaticHelper.utf8LengthToPascalLength(this.getStringValue());
        FieldWriterFactory.writeImplicitField("sLength", sLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        int stringLength = this.getStringLength();
        writeBuffer.writeVirtual("stringLength", stringLength, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("stringValue", this.stringValue, DataWriterFactory.writeString(writeBuffer, stringLength * 8), new WithWriterArgs[0]);
        writeBuffer.popContext("PascalString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        PascalString _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += this.getStringLength() * 8;
    }

    public static PascalString staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return PascalString.staticParse(readBuffer);
    }

    public static PascalString staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("PascalString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int sLength = FieldReaderFactory.readImplicitField("sLength", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        int stringLength = FieldReaderFactory.readVirtualField("stringLength", Integer.TYPE, StaticHelper.pascalLengthToUtf8Length(sLength), new WithReaderArgs[0]);
        String stringValue = FieldReaderFactory.readSimpleField("stringValue", DataReaderFactory.readString(readBuffer, stringLength * 8), new WithReaderArgs[0]);
        readBuffer.closeContext("PascalString", new WithReaderArgs[0]);
        PascalString _pascalString = new PascalString(stringValue);
        return _pascalString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PascalString)) {
            return false;
        }
        PascalString that = (PascalString)o;
        return this.getStringValue() == that.getStringValue();
    }

    public int hashCode() {
        return Objects.hash(this.getStringValue());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

