/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class RelativePath
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfElements;
    protected final List<ExtensionObjectDefinition> elements;

    @Override
    public String getIdentifier() {
        return "542";
    }

    public RelativePath(int noOfElements, List<ExtensionObjectDefinition> elements) {
        this.noOfElements = noOfElements;
        this.elements = elements;
    }

    public int getNoOfElements() {
        return this.noOfElements;
    }

    public List<ExtensionObjectDefinition> getElements() {
        return this.elements;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RelativePath", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfElements", this.noOfElements, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("elements", this.elements, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("RelativePath", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        RelativePath _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.elements != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.elements) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.elements.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("RelativePath", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfElements = FieldReaderFactory.readSimpleField("noOfElements", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> elements = FieldReaderFactory.readCountArrayField("elements", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "539"), readBuffer), noOfElements, new WithReaderArgs[0]);
        readBuffer.closeContext("RelativePath", new WithReaderArgs[0]);
        return new RelativePathBuilderImpl(noOfElements, elements);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelativePath)) {
            return false;
        }
        RelativePath that = (RelativePath)o;
        return this.getNoOfElements() == that.getNoOfElements() && this.getElements() == that.getElements() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfElements(), this.getElements());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RelativePathBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfElements;
        private final List<ExtensionObjectDefinition> elements;

        public RelativePathBuilderImpl(int noOfElements, List<ExtensionObjectDefinition> elements) {
            this.noOfElements = noOfElements;
            this.elements = elements;
        }

        @Override
        public RelativePath build() {
            RelativePath relativePath = new RelativePath(this.noOfElements, this.elements);
            return relativePath;
        }
    }
}

