/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class RequestHeader
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId authenticationToken;
    protected final long timestamp;
    protected final long requestHandle;
    protected final long returnDiagnostics;
    protected final PascalString auditEntryId;
    protected final long timeoutHint;
    protected final ExtensionObject additionalHeader;

    @Override
    public String getIdentifier() {
        return "391";
    }

    public RequestHeader(NodeId authenticationToken, long timestamp, long requestHandle, long returnDiagnostics, PascalString auditEntryId, long timeoutHint, ExtensionObject additionalHeader) {
        this.authenticationToken = authenticationToken;
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.returnDiagnostics = returnDiagnostics;
        this.auditEntryId = auditEntryId;
        this.timeoutHint = timeoutHint;
        this.additionalHeader = additionalHeader;
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRequestHandle() {
        return this.requestHandle;
    }

    public long getReturnDiagnostics() {
        return this.returnDiagnostics;
    }

    public PascalString getAuditEntryId() {
        return this.auditEntryId;
    }

    public long getTimeoutHint() {
        return this.timeoutHint;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RequestHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("authenticationToken", this.authenticationToken, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timestamp", this.timestamp, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHandle", this.requestHandle, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("returnDiagnostics", this.returnDiagnostics, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("auditEntryId", this.auditEntryId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timeoutHint", this.timeoutHint, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("additionalHeader", this.additionalHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("RequestHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        RequestHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.authenticationToken.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.auditEntryId.getLengthInBits();
        lengthInBits += 32;
        return lengthInBits += this.additionalHeader.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("RequestHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId authenticationToken = FieldReaderFactory.readSimpleField("authenticationToken", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long timestamp = FieldReaderFactory.readSimpleField("timestamp", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        long requestHandle = FieldReaderFactory.readSimpleField("requestHandle", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long returnDiagnostics = FieldReaderFactory.readSimpleField("returnDiagnostics", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        PascalString auditEntryId = FieldReaderFactory.readSimpleField("auditEntryId", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long timeoutHint = FieldReaderFactory.readSimpleField("timeoutHint", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        ExtensionObject additionalHeader = FieldReaderFactory.readSimpleField("additionalHeader", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("RequestHeader", new WithReaderArgs[0]);
        return new RequestHeaderBuilderImpl(authenticationToken, timestamp, requestHandle, returnDiagnostics, auditEntryId, timeoutHint, additionalHeader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestHeader)) {
            return false;
        }
        RequestHeader that = (RequestHeader)o;
        return this.getAuthenticationToken() == that.getAuthenticationToken() && this.getTimestamp() == that.getTimestamp() && this.getRequestHandle() == that.getRequestHandle() && this.getReturnDiagnostics() == that.getReturnDiagnostics() && this.getAuditEntryId() == that.getAuditEntryId() && this.getTimeoutHint() == that.getTimeoutHint() && this.getAdditionalHeader() == that.getAdditionalHeader() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAuthenticationToken(), this.getTimestamp(), this.getRequestHandle(), this.getReturnDiagnostics(), this.getAuditEntryId(), this.getTimeoutHint(), this.getAdditionalHeader());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RequestHeaderBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId authenticationToken;
        private final long timestamp;
        private final long requestHandle;
        private final long returnDiagnostics;
        private final PascalString auditEntryId;
        private final long timeoutHint;
        private final ExtensionObject additionalHeader;

        public RequestHeaderBuilderImpl(NodeId authenticationToken, long timestamp, long requestHandle, long returnDiagnostics, PascalString auditEntryId, long timeoutHint, ExtensionObject additionalHeader) {
            this.authenticationToken = authenticationToken;
            this.timestamp = timestamp;
            this.requestHandle = requestHandle;
            this.returnDiagnostics = returnDiagnostics;
            this.auditEntryId = auditEntryId;
            this.timeoutHint = timeoutHint;
            this.additionalHeader = additionalHeader;
        }

        @Override
        public RequestHeader build() {
            RequestHeader requestHeader = new RequestHeader(this.authenticationToken, this.timestamp, this.requestHandle, this.returnDiagnostics, this.auditEntryId, this.timeoutHint, this.additionalHeader);
            return requestHeader;
        }
    }
}

