/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ResponseHeader
extends ExtensionObjectDefinition
implements Message {
    protected final long timestamp;
    protected final long requestHandle;
    protected final StatusCode serviceResult;
    protected final DiagnosticInfo serviceDiagnostics;
    protected final int noOfStringTable;
    protected final List<PascalString> stringTable;
    protected final ExtensionObject additionalHeader;

    @Override
    public String getIdentifier() {
        return "394";
    }

    public ResponseHeader(long timestamp, long requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, int noOfStringTable, List<PascalString> stringTable, ExtensionObject additionalHeader) {
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.serviceResult = serviceResult;
        this.serviceDiagnostics = serviceDiagnostics;
        this.noOfStringTable = noOfStringTable;
        this.stringTable = stringTable;
        this.additionalHeader = additionalHeader;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRequestHandle() {
        return this.requestHandle;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.serviceDiagnostics;
    }

    public int getNoOfStringTable() {
        return this.noOfStringTable;
    }

    public List<PascalString> getStringTable() {
        return this.stringTable;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ResponseHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timestamp", this.timestamp, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHandle", this.requestHandle, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serviceResult", this.serviceResult, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serviceDiagnostics", this.serviceDiagnostics, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfStringTable", this.noOfStringTable, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("stringTable", this.stringTable, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("additionalHeader", this.additionalHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("ResponseHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ResponseHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += this.serviceResult.getLengthInBits();
        lengthInBits += this.serviceDiagnostics.getLengthInBits();
        lengthInBits += 32;
        if (this.stringTable != null) {
            int i = 0;
            for (PascalString element : this.stringTable) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.stringTable.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits += this.additionalHeader.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ResponseHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long timestamp = FieldReaderFactory.readSimpleField("timestamp", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        long requestHandle = FieldReaderFactory.readSimpleField("requestHandle", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        StatusCode serviceResult = FieldReaderFactory.readSimpleField("serviceResult", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        DiagnosticInfo serviceDiagnostics = FieldReaderFactory.readSimpleField("serviceDiagnostics", new DataReaderComplexDefault<DiagnosticInfo>(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfStringTable = FieldReaderFactory.readSimpleField("noOfStringTable", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<PascalString> stringTable = FieldReaderFactory.readCountArrayField("stringTable", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), noOfStringTable, new WithReaderArgs[0]);
        ExtensionObject additionalHeader = FieldReaderFactory.readSimpleField("additionalHeader", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("ResponseHeader", new WithReaderArgs[0]);
        return new ResponseHeaderBuilderImpl(timestamp, requestHandle, serviceResult, serviceDiagnostics, noOfStringTable, stringTable, additionalHeader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseHeader)) {
            return false;
        }
        ResponseHeader that = (ResponseHeader)o;
        return this.getTimestamp() == that.getTimestamp() && this.getRequestHandle() == that.getRequestHandle() && this.getServiceResult() == that.getServiceResult() && this.getServiceDiagnostics() == that.getServiceDiagnostics() && this.getNoOfStringTable() == that.getNoOfStringTable() && this.getStringTable() == that.getStringTable() && this.getAdditionalHeader() == that.getAdditionalHeader() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTimestamp(), this.getRequestHandle(), this.getServiceResult(), this.getServiceDiagnostics(), this.getNoOfStringTable(), this.getStringTable(), this.getAdditionalHeader());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ResponseHeaderBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long timestamp;
        private final long requestHandle;
        private final StatusCode serviceResult;
        private final DiagnosticInfo serviceDiagnostics;
        private final int noOfStringTable;
        private final List<PascalString> stringTable;
        private final ExtensionObject additionalHeader;

        public ResponseHeaderBuilderImpl(long timestamp, long requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, int noOfStringTable, List<PascalString> stringTable, ExtensionObject additionalHeader) {
            this.timestamp = timestamp;
            this.requestHandle = requestHandle;
            this.serviceResult = serviceResult;
            this.serviceDiagnostics = serviceDiagnostics;
            this.noOfStringTable = noOfStringTable;
            this.stringTable = stringTable;
            this.additionalHeader = additionalHeader;
        }

        @Override
        public ResponseHeader build() {
            ResponseHeader responseHeader = new ResponseHeader(this.timestamp, this.requestHandle, this.serviceResult, this.serviceDiagnostics, this.noOfStringTable, this.stringTable, this.additionalHeader);
            return responseHeader;
        }
    }
}

