/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SecurityHeader
implements Message {
    protected final long secureChannelId;
    protected final long secureTokenId;

    public SecurityHeader(long secureChannelId, long secureTokenId) {
        this.secureChannelId = secureChannelId;
        this.secureTokenId = secureTokenId;
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    public long getSecureTokenId() {
        return this.secureTokenId;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SecurityHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("secureChannelId", this.secureChannelId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("secureTokenId", this.secureTokenId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("SecurityHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        SecurityHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static SecurityHeader staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return SecurityHeader.staticParse(readBuffer);
    }

    public static SecurityHeader staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("SecurityHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long secureChannelId = FieldReaderFactory.readSimpleField("secureChannelId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        long secureTokenId = FieldReaderFactory.readSimpleField("secureTokenId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("SecurityHeader", new WithReaderArgs[0]);
        SecurityHeader _securityHeader = new SecurityHeader(secureChannelId, secureTokenId);
        return _securityHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityHeader)) {
            return false;
        }
        SecurityHeader that = (SecurityHeader)o;
        return this.getSecureChannelId() == that.getSecureChannelId() && this.getSecureTokenId() == that.getSecureTokenId();
    }

    public int hashCode() {
        return Objects.hash(this.getSecureChannelId(), this.getSecureTokenId());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

